package com.bxm.adx.common.micrometer.aspect;

import com.bxm.adx.common.algorithm.ModelService;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ClassUtils;

import java.util.Map;

/**
 * @author fgf
 * @date 2023/3/7
 **/
@Slf4j
public class ModelServiceMicroMeter implements MeterBinder {

    private final Map<Class, Timer> timers = Maps.newConcurrentMap();
    private final Iterable<ModelService> modelServices;

    public ModelServiceMicroMeter(Iterable<ModelService> modelServices) {
        this.modelServices = modelServices;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        for (ModelService service : modelServices) {
            Class<?> clazz = ClassUtils.getUserClass(service);
            Timer timer = Timer.builder("algo.model").tag("name", clazz.getName()).register(registry);
            timers.put(clazz, timer);
            log.info("Registering Algo Model {} timer meter successful.", service);
        }
    }

    Timer get(ModelService service) {
        return timers.get(ClassUtils.getUserClass(service));
    }
}
