package com.bxm.adx.common.micrometer.aspect;

import com.bxm.adx.common.algorithm.ModelService;
import io.micrometer.core.instrument.Timer;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @author fgf
 * @date 2023/3/7
 **/
@Aspect
public class ModelServiceMicroMeterAspect {
    private final ModelServiceMicroMeter microMeter;

    public ModelServiceMicroMeterAspect(ModelServiceMicroMeter microMeter) {
        this.microMeter = microMeter;
    }

    @Pointcut("this(com.bxm.adx.common.algorithm.ModelService) && execution(* call(..))")
    public void pointcut() {}

    @Around("pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof ModelService)) {
            return point.proceed();
        }
        ModelService service = (ModelService) target;
        Timer timer = microMeter.get(service);
        long start = System.nanoTime();
        try {
            return point.proceed();
        } finally {
            if (Objects.nonNull(timer)) {
                timer.record((System.nanoTime() - start), TimeUnit.NANOSECONDS);
            }
        }
    }
}
