package com.bxm.adx.common.openlog.event.internal;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import lombok.Data;

import java.util.EventObject;

/**
 * @author fgf
 * @date 2025/2/28
 **/
@Data
public class AdxAlgorithmEvent extends EventObject {
    private final BidRequest sspRequest;
    private final BidResponse adxResponse;
    private final String modelId;
    private final String version;
    private final String returnValue;

    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param sspRequest
     * @param adxResponse
     * @param modelId
     * @param version
     * @param returnValue
     * @throws IllegalArgumentException if source is null.
     */
    public AdxAlgorithmEvent(Object source, BidRequest sspRequest, BidResponse adxResponse, String modelId, String version, String returnValue) {
        super(source);
        this.sspRequest = sspRequest;
        this.adxResponse = adxResponse;
        this.modelId = modelId;
        this.version = version;
        this.returnValue = returnValue;
    }
}
