package com.bxm.adx.common.openlog.listener.external;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.external.AdFeedBackEvent;
import com.bxm.adx.common.report.AttributionReportService;
import com.bxm.adx.common.utils.DateUtils;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * @author fgf
 * @date 2025/5/8
 **/
@Slf4j
//@Configuration
public class AdFeedBackForAttributionEventListener implements EventListener<AdFeedBackEvent> {
    private final static List<String> TRANSFORM_TYPE = Lists.newArrayList("12", "6");
    private final JedisPool jedisPool;

    public AdFeedBackForAttributionEventListener(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdFeedBackEvent event) {
        KeyValueMap map = event.getLog();
        String transformType = map.getFirst(OpenlogConstants.ConversionMacros.TransformType);
        if (transformType == null) {
            return;
        }
        if (!TRANSFORM_TYPE.contains(transformType)) {
            return;
        }
        String bidId = map.getFirst(OpenlogConstants.ConversionMacros.Bidid);
        pushBidId(bidId);
    }

    private void pushBidId(String bidId) {
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern(DateUtils.PATTERN_DATE));
        String key = CacheKeys.ServerReport.getAttributionBidKey(date).generateKey();
        try (Jedis jedis = jedisPool.getResource()) {
            try (Pipeline pipeline = jedis.pipelined()) {
                pipeline.select(AttributionReportService.DB);
                pipeline.lpush(key, bidId);
                pipeline.expire(key, AttributionReportService.EXPIRE);
                List<Object> response = pipeline.syncAndReturnAll();
                if (log.isDebugEnabled()) {
                    log.debug("pipeline response {}", response);
                }
            }
        } catch (Exception e) {
            log.error("save exceed err {}, affect {}", e.getMessage(), bidId);
        }
    }
}
