package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.AdxAlgorithmEvent;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import lombok.Builder;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/**
 * @author fgf
 * @date 2025/2/28
 **/
@Configuration
public class DotAdxAlgorithmEventListener implements EventListener<AdxAlgorithmEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DotAdxAlgorithmEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdxAlgorithmEvent event) {
        MultiValueMap<String, String> customizeParams = buildCustomizeParams(event);
        String url = properties.getOpenLog().create(true, OpenlogConstants.Mt.ALGO, customizeParams, OpenlogConstants.WITHOUT_MACROS_INNER);
        Long dspId = event.getAdxResponse().getSeat_bid().iterator().next().getDspId();
        BuildAttribute attribute = new BuildAttribute(OpenlogConstants.Mt.ALGO)
                .setDspId(dspId)
                .setSspRequest(event.getSspRequest())
                .setAdxResponse(event.getAdxResponse())
                .setStrategyId(event.getAdxResponse().getSeat_bid().iterator().next().getStrategyId());
        url = macrosHandler.replaceAll(url, attribute);
        openLogClient.asyncRequest(url);
    }

    /**
     * 构建客制化埋点参数
     */
    private MultiValueMap<String, String> buildCustomizeParams(AdxAlgorithmEvent event) {
        MultiValueMap<String, String> customizeParams = new LinkedMultiValueMap<>();
        AlgoInfo algoInfo = AlgoInfo.builder()
                .id(event.getModelId())
                .ver(event.getVersion())
                .val(event.getReturnValue())
                .build();
        customizeParams.add(OpenlogConstants.MacrosCustomizeParams.ALGO_INFO, UrlHelper.urlEncode(JsonHelper.convert(algoInfo)));
        return customizeParams;
    }

    @Data
    @Builder
    public static class AlgoInfo {
        private String id;
        private String ver;
        private String val;
    }
}
