package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.buy.dsp.domainmapping.AdxDomainMappingConfigCached;
import com.bxm.adx.common.openlog.event.internal.AdxBidEvent;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author fgf
 * @date 2022/6/1
 **/
@Configuration
public class DotAdxBidEventListener implements EventListener<AdxBidEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;
    private final AdxDomainMappingConfigCached adxDomainMappingConfigCached;

    public DotAdxBidEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler, AdxDomainMappingConfigCached adxDomainMappingConfigCached) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
        this.adxDomainMappingConfigCached = adxDomainMappingConfigCached;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdxBidEvent event) {
        if (Math.abs(event.getSspRequest().getId().hashCode() % 100) >= properties.getDotSimplingPercent()) {
            return;
        }
        MultiValueMap<String, String> customizeParams = buildCustomizeParams(event);
        String url = properties.getOpenLog().create(true, OpenlogConstants.Mt.ADX_RESPONSE_MT, customizeParams, OpenlogConstants.WITHOUT_MACROS_INNER);
        Long dspId = event.getAdxResponse().getSeat_bid().iterator().next().getDspId();
        BuildAttribute attribute = new BuildAttribute(OpenlogConstants.Mt.ADX_RESPONSE_MT)
                .setDspId(dspId)
                .setSspRequest(event.getSspRequest())
                .setAdxResponse(event.getAdxResponse())
                .setStrategyId(event.getAdxResponse().getSeat_bid().iterator().next().getStrategyId());
        url = macrosHandler.replaceAll(url, attribute);
        openLogClient.asyncRequest(url);
    }

    /**
     * 构建客制化埋点参数
     */
    private MultiValueMap<String, String> buildCustomizeParams(AdxBidEvent event) {
        MultiValueMap<String, String> customizeParams = new LinkedMultiValueMap<>();
        List<DotAdxBidEventListener.Creative> creatives = getCreatives(event.getAdxResponse());
        String value = UrlHelper.urlEncode(JsonHelper.convert(creatives));
        customizeParams.add(OpenlogConstants.MacrosCustomizeParams.BID_CREATIVES, value);
        BidRequest request = event.getSspRequest();
        Device device = request.getDevice();
        if (Objects.nonNull(device)) {
            String verCodeOfHms = device.getVer_code_of_hms();
            if (StringUtils.isNotBlank(verCodeOfHms)) {
                customizeParams.add(OpenlogConstants.MacrosCustomizeParams.HMS_VER, verCodeOfHms);
            }
        }
        return customizeParams;
    }

    /**
     * 参竞广告详情
     * @param bidResponse
     * @return
     */
    private List<DotAdxBidEventListener.Creative> getCreatives(BidResponse bidResponse) {
        List<DotAdxBidEventListener.Creative> creatives = new ArrayList<>();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                String price = "";
                Integer budgetType = bid.getBudget_type();
                if (Objects.nonNull(budgetType)){
                    switch (budgetType){
                        case AdxConstants.ChargeType.CPM:
                            price = bid.getPrice().toString();
                            break;
                        case AdxConstants.ChargeType.CPC:
                            price = bid.getBid().toString();
                            break;
                        case AdxConstants.ChargeType.OCPM:
                            price = bid.getObid().toString();
                            break;
                        default:
                            break;
                    }
                }
                Creative creative = new Creative()
                        .setCreativeId(bid.getCreate_id())
                        .setTicketId(bid.getAdid())
                        .setBdgtyp(bid.getBudget_type())
                        .setPrice(price)
                        .setTid(bid.getTask_id())
                        .setDpcid(bid.getDpc_id())
                        .setDspId(seatBid.getDspId())
                        .setDappid(bid.getDsp_appid())
                        .setDtagid(bid.getTag_id())
                        .setConfigid(seatBid.getConfigId())
                        .setUsl(bid.getUser_score_level())
                        .setDpcsid(bid.getDpc_strategy_id())
                        .setDid(adxDomainMappingConfigCached.getDomainId(bid))
                        ;
                creatives.add(creative);
            }
        }
        return creatives;
    }

    @Data
    @Accessors(chain = true)
    private static class Creative {
        private String creativeId;
        private String ticketId;
        private String price;
        private String tid;
        private String dpcid;
        private Integer bdgtyp;
        private Long dspId;
        private String dappid;
        private String dtagid;
        private Long configid;
        private Integer usl;
        private Integer transType;
        private String dpcsid;
        private Long did;
    }
}
