package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.Click302Event;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * 点击落地页302跳转埋点
 *
 * @author fgf
 * @date 2022/9/16
 **/
@Configuration
public class DotClick302EventListener implements EventListener<Click302Event> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;

    public DotClick302EventListener(AdxProperties properties) {
        this.properties = properties;
    }


    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(Click302Event event) {
        String tagid = event.getTagid();
        String bidid = event.getBidid();
        String reqx = event.getReqx();
        if (StringUtils.isEmpty(tagid) || StringUtils.isEmpty(bidid) || StringUtils.isEmpty(reqx)) {
            return;
        }
        List<String> positions = properties.getHeadMonitorPositions();
        if (CollectionUtils.isNotEmpty(positions) && positions.contains(tagid)) {
            String url = properties.getOpenLog().create(true, OpenlogConstants.Mt.CLICK_302_MT);
            url = url.replace(OpenlogConstants.Macros.BIDID, bidid)
                    .replace(OpenlogConstants.Macros.TAGID, tagid)
                    .replace(OpenlogConstants.Macros.XREQW, reqx);
            openLogClient.asyncRequest(url);
        }
    }
}
