package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.limiter.InsertExpireHandler;
import com.bxm.adx.common.openlog.event.internal.MediaRequestEvent;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.User;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Objects;

/**
 * @author fgf
 * @date 2022/6/1
 **/
@Slf4j
@Configuration
public class DotMediaRequestCrowdEventListener implements EventListener<MediaRequestEvent> {
    private final static List<String> MEDIA_LIST = Lists.newArrayList(AdxConstants.Media.Bes.getId() + "",
            AdxConstants.Media.Bxm.getId() + "");
    private final static Long EXPIRE = 7 * 24 * 3600L;
    private final InsertExpireHandler insertExpireHandler;
    private final static String CROWD_ID = "204";
    public DotMediaRequestCrowdEventListener(InsertExpireHandler insertExpireHandler) {
        this.insertExpireHandler = insertExpireHandler;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(MediaRequestEvent event) {
        BidRequest request = event.getSspRequest();
        if (!MEDIA_LIST.contains(request.getMediaId())) {
            return;
        }
        User user = request.getUser();
        if (Objects.nonNull(user)) {
            String keywords = user.getKeywords();
            if (StringUtils.isNotBlank(keywords) && keywords.contains(CROWD_ID)) {
                List<KeyGenerator> keys = CacheKeys.getCrowdPackageNewKeys(event.getSspRequest().getDevice());
                if (CollectionUtils.isNotEmpty(keys)) {
                    long crowdExpire = System.currentTimeMillis() / 1000 + EXPIRE;
                    long keyExpire = EXPIRE;
                    keys.forEach(key -> {
                        insertExpireHandler.insert(key, CROWD_ID, crowdExpire + "", (int) keyExpire);});
                }
            }
        }
    }
}
