package com.bxm.adx.common.sell.init;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.sell.BidRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author zhangdong
 * @date 2022/10/17
 */
@Component
public class ConfigInitializer implements BidRequestInitializer {


    @Autowired
    private AdxProperties adxProperties;


    @Override
    public void accept(BidRequest request, InitializerParam param) {
        String sspName = AdxContextFactory.get().getName();
        AdxProperties.SspConfig sspConfig = adxProperties.getSspConfig().get(sspName);
        if (sspConfig == null || request == null) {
            return;
        }
        request.setMediaId(sspConfig.getMediaId());
        request.setEncModel(sspConfig.getEncryptionModel());
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
