package com.bxm.adx.common.sell.position.mapping;

import com.bxm.adx.common.PositionMappingProperties;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Impression;

import java.util.List;

/**
 * 广告位映射策略
 *
 * @author fgf
 * @date 2023/2/22
 **/
public interface PositionMappingStrategy {

    /**
     * 策略类型
     * @return
     */
    Strategy strategy();

    /**
     * 广告位映射
     * @param bidRequest
     * @param impression
     * @return
     */
    Position mapping(BidRequest bidRequest, Impression impression, PositionMappingProperties properties);
}
