package com.bxm.adx.common.sell.settings;

import lombok.Data;

import java.util.Objects;

/**
 * @author fgf
 * @date 2024/12/24
 **/
@Data
public class MediaInstalledAppMapping {
    private String id;

    /**
     * 开发者 id
     */
    private String developerId;

    /**
     * 开发者名称
     */
    private String developerName;

    /**
     * 已安装 app 名称
     */
    private String installedAppName;

    /**
     * 已安装 app 包名
     */
    private String installedPackageName;

    /**
     * 媒体已安装 app 标识
     */
    private String mediaInstalledCode;

    /**
     * 是否删除,1:已删除
     */
    private Integer deleted;

    public String getUniqueKey() {
        return developerId + ":" + mediaInstalledCode;
    }

    public boolean isDelete() {
        return Objects.nonNull(deleted) && deleted == 1;
    }
}
