package com.bxm.adx.common.utils;

import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @Author: Areit
 * @Date: 2019-10-14 11:11
 */
public class DateUtils {
    public final static String PATTERN_SECOND = "yyyyMMdd HH:mm:ss";
    public final static String PATTERN_DATE = "yyyyMMdd";
    public final static DateTimeFormatter FORMAT_SIMPLE = DateTimeFormatter.ofPattern(PATTERN_DATE);
    public static LocalDate convertDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        return localDate;
    }

    /**
     * 只判断日期，不判断具体时间&&注意是[,]非(,]/(,)/[,)
     *
     * @param start
     * @param end
     * @return
     */
    public static boolean isBetween(Date start, Date end) {
        LocalDate now = LocalDate.now();
        LocalDate s = convertDate(start);
        LocalDate e = convertDate(end);
        if (now.isAfter(s) && now.isBefore(e)) {
            return true;
        } else if (now.isEqual(s) || now.isEqual(e)) {
            return true;
        } else {
            return false;
        }
    }

    public static LocalDateTime convertLocalDateTime(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(PATTERN_SECOND);
        LocalDateTime localDateTime = LocalDateTime.parse(date, formatter);
        return localDateTime;
    }

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        return DateTimeFormatter.ofPattern(pattern);
    }

    public static long getDuration(Date date) {
        Date now = new Date();
        long differenceInMillis = now.getTime() - date.getTime();
        // 将差异转换为分钟
        long differenceInMinutes = differenceInMillis / (60 * 1000);
        return differenceInMinutes;
    }

    public static long getInitialDelayForDaily(int hour, int minute) {
        // 获取当前时间
        LocalDateTime now = LocalDateTime.now();

        LocalDateTime nextRun = now.withHour(hour).withMinute(minute).withSecond(0).withNano(0);

        // 如果当前时间已经超过了设定的时间，则推迟到明天同一时间
        if (now.isAfter(nextRun)) {
            nextRun = nextRun.plusDays(1);
        }

        // 计算当前时间与下次执行时间的间隔
        Duration duration = Duration.between(now, nextRun);
        return duration.toMillis();
    }
}
