package com.bxm.adx.common;

import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author allen
 * @since 2019-12-16
 */
public class AdxConstants {
    public static final Integer RESULT_OK = 0;

    public static final byte YES = 1;
    public static final byte NO = 0;

    public static final int ADX_REQ = 15001;
    public static final int ADX_RESP = 15104;
    public static final int DSP_REQ = 15002;
    public static final int DSP_RESP = 15103;

    //    public static final String KUGOU_SDK_VERSION = "3.5.2.1601";
    public static final String PUSH_POSITION_VERSION = "3.5.9";

    public static final String SDK_ERR_CODE_VERSION = "3.7.0";

    public static final Long SDK_WAIT_TIME = 450L;
    public static final Long API_WAIT_TIME = 120L;
    public static final Long SDK_OVER_TIME = 500L;
    public static final Long API_OVER_TIME = 150L;

    /**
     * SDK特定位置广告请求方式
     * 定时/主动
     */
    public interface RequestModel {
        int TIMING = 1;
        int DRIVING = 2;
    }

    /**
     * 广告创意类型
     */
    public enum Type {
        NATIVE(1),
        IMAGE(2),
        VIDEO(3),
        TEXT(4),
        INSPIRE_VIDEO(5),
        ANIMATION_POPUP(6);

        private Integer type;

        Type(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return type;
        }

        public static Integer getTypeByPositionScene(Byte scene) {
            PositionSceneTypeEnum sceneTypeEnum = PositionSceneTypeEnum.get(scene.intValue());
            if (sceneTypeEnum == null) {
                return null;
            }
            switch (sceneTypeEnum) {
                case INFORMATION_FLOW:
                    return NATIVE.getType();
                case BOOT:
                    return IMAGE.getType();
                case SCREEN:
                    return IMAGE.getType();
                case BUTTON:
                    return IMAGE.getType();
                case INFORMATION_FLOW_SELF_RENDERING:
                    return NATIVE.getType();
                case BANNER:
                    return IMAGE.getType();
                case ICON:
                    return IMAGE.getType();
                case VIDEO:
                    return VIDEO.getType();
                case INSPIRE_VIDEO:
                    return INSPIRE_VIDEO.getType();
                case SELF_RENDERING:
                    return NATIVE.getType();
                case INFORMATION_FLOW_IMMERSIVE_VIDEO:
                    return VIDEO.getType();
                case TAB_PAGE:
                    return NATIVE.getType();
                case PUSH:
                    return NATIVE.getType();

            }
            return null;
        }

        public static Integer getTypeByImpType(Integer impType) {
            PositionSceneTypeEnum sceneTypeEnum = PositionSceneTypeEnum.get(impType);
            if (sceneTypeEnum == null) {
                return null;
            }
            switch (sceneTypeEnum) {
                case INFORMATION_FLOW:
                    return NATIVE.getType();
                case BOOT:
                    return IMAGE.getType();
                case SCREEN:
                    return IMAGE.getType();
                case BUTTON:
                    return IMAGE.getType();
                case INFORMATION_FLOW_SELF_RENDERING:
                    return NATIVE.getType();
                case BANNER:
                    return IMAGE.getType();
                case ICON:
                    return IMAGE.getType();
                case VIDEO:
                    return VIDEO.getType();
                case INSPIRE_VIDEO:
                    return INSPIRE_VIDEO.getType();
                case SELF_RENDERING:
                    return NATIVE.getType();
                case INFORMATION_FLOW_IMMERSIVE_VIDEO:
                    return VIDEO.getType();
                case TAB_PAGE:
                    return NATIVE.getType();
                case PUSH:
                    return NATIVE.getType();

            }
            return null;
        }
    }

    /**
     * ssp协议广告点击操作类型对应adx协议CType
     */
    public enum Action {
        UNKNOW(0),
        DOWNLOAD_ANDROID(2),
        DOWNLOAD_IOS(3),
        WEB_VIEW(6),
        DEEP_LINK(9),
        DEEP_LINK_DOWNLOAD(11),
        INSPIRE_BROWSE(12),
        DOWNLOAD(13),
        /**
         * 广点通下载类广告
         */
        GDT_DOWNLOAD(14),
        /**
         * 广点通跳转广告
         */
        GDT_JUMP(15),
        ;
        public int action;

        Action(int action) {
            this.action = action;
        }

        public int getAction() {
            return action;
        }

        public static boolean isAppDownload(Integer action) {
            if (action == null) {
                return false;
            }
            Action act = Arrays.stream(Action.values())
                    .filter(a -> a.getAction() == action.intValue())
                    .findFirst()
                    .orElse(UNKNOW);
            if (act == DOWNLOAD_ANDROID || act == DOWNLOAD_IOS || act == DEEP_LINK_DOWNLOAD) {
                return true;
            } else {
                return false;
            }
        }

        public static Action getAction(Integer action) {
            if (Objects.isNull(action)) {
                return Action.UNKNOW;
            }
            return Arrays.stream(Action.values()).filter(a -> a.action == action).findFirst().orElse(Action.UNKNOW);
        }
    }

    /**
     * 场景dsp出活动错误类型
     */
    public enum ActivityErr {
        DOUDI,
        MEI_DOU_ZHU
    }

    /**
     * 内部埋点modeltype
     */
    public enum CounterMt {
        IMP("1"),
        CLICK("2"),

        V_START("3"),
        V_1_4("4"),
        V_1_2("5"),
        V_3_4("6"),
        V_END("7"),
        V_MUTE("8"),
        V_SKIP("9"),
        V_CLOSED("10"),
        V_SUSPEND("11"),
        V_PROCEED("12"),
        V_BAD_NET("18"),
        V_FULL_SCREEN_PLAY("19"),
        V_CLOSE_FULL_SCREEN_PLAY("20"),
        V_CLOSE_MUTE_PLAY("21"),
        V_LEAVE("26"),
        V_ABANDON("29"),
        V_END_PAGE_EXPOSE("30"),
        V_INTERCEPT_EXPOSE("31"),

        APP_D_START("13"),
        APP_D_END("14"),
        APP_IN_START("15"),
        APP_IN_END("16"),
        APP_ACT("22"),

        DP_START("23"),
        DP_SUCCESS("24"),
        DP_FAIL("25"),

        IMP_FAIL("27"),
        CLICK_FAIL("28");
        private String mt;

        CounterMt(String mt) {
            this.mt = mt;
        }

        public String getMt() {
            return mt;
        }
    }

    /**
     * 网络类型
     */
    public enum ConnectionType {
        UNKNOW(0, "unknow"),
        WIFI(1, "wifi"),
        UNKNOW_XG(2, "xg"),
        _2G(3, "2g"),
        _3G(4, "3g"),
        _4G(5, "4g"),
        _5G(6, "5g"),
        ETHERNET(7, "ethernet");
        private Integer type;
        private String network;

        ConnectionType(Integer type, String network) {
            this.type = type;
            this.network = network;
        }

        public Integer getType() {
            return type;
        }

        public String getNetwork() {
            return network;
        }

        public static Integer getType(String typeStr) {
            if (StringUtils.isEmpty(typeStr)) {
                return UNKNOW.type;
            }
            return Arrays.stream(ConnectionType.values()).
                    filter(connectionType -> connectionType.network.equalsIgnoreCase(typeStr))
                    .findFirst().orElse(UNKNOW).type;
        }

        public static ConnectionType getType(Integer type) {
            if (type == null) {
                return UNKNOW;
            }
            return Arrays.stream(ConnectionType.values()).
                    filter(connectionType -> connectionType.type.equals(type))
                    .findFirst().orElse(UNKNOW);
        }

        public static ConnectionType getType(Integer type, String os) {
            if (type == null) {
                return UNKNOW;
            }
            if (StringUtils.isEmpty(os)) {
                return UNKNOW;
            }
            if (!"ios".equalsIgnoreCase(os)) {
                return UNKNOW;
            }
            switch (type) {
                case 1:
                    return WIFI;
                case 2:
                    return _2G;
                case 3:
                    return _3G;
                case 4:
                    return _4G;
                default:
                    return UNKNOW;
            }
        }
    }

    /**
     * 运营商
     */
    public enum Carrier {
        MOBILE(0),
        TELECOM(1),
        UNICOM(3),
        UNKNOW(4);
        public Integer carrier;

        Carrier(Integer carrier) {
            this.carrier = carrier;
        }

        public static Carrier getCarrier(Integer carrier) {
            if (carrier == null) {
                return UNKNOW;
            }
            return Arrays.stream(Carrier.values()).
                    filter(carrier1 -> carrier1.carrier.equals(carrier)).findFirst().orElse(UNKNOW);
        }
    }

    /**
     * 上报宏参替换
     */
    public enum Macro {
        __X_DOWN__,
        __Y_DOWN__,
        __X_UP__,
        __Y_UP__,
        __REQPW__,
        __REQPH__,
        __ACTPW__,
        __ACTPH__,
        __VI_DURATION__,
        __STATUS__;
    }

    /**
     * 素材类型
     */
    public enum AssetType {
        UNKNOW(0),
        /**
         * 标题
         */
        TITLE(1),
        /**
         * 内容
         */
        CONTENT(2),
        /**
         * 按钮文本
         */
        BTN_TEXT(3),
        /**
         * 按钮内容
         */
        BTN_CONTENT(4),
        PRICE(5),
        ICON(6),
        LARGE_IMG(7),
        BTN_IMG(8),
        DESC(9),
        RATING(10),
        /**
         * 全屏视频
         */
        VIDEO(11),
        /**
         * 激励视频
         */
        REWARDER_VIDEO(12),
        /**
         * 品牌名等
         */
        BRAND_NAME(15),
        /**
         * 弹窗素材信息
         */
        POPUP_ASSET_INFO(16),
        /**
         * 弹窗web页地址信息
         */
        POPUP_WEB_URL(17);
        private Integer type;

        AssetType(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return type;
        }

        public static AssetType getAssetType(Integer type) {
            if (type == null) {
                return UNKNOW;
            }
            return Arrays.stream(AssetType.values())
                    .filter(at -> at.type.equals(type))
                    .findFirst()
                    .orElse(UNKNOW);
        }
    }

    public enum Imsi {
        MOBILE("46000"),
        UNICOM("46001"),
        TELECOM("46003");
        private String imsi;

        Imsi(String imsi) {
            this.imsi = imsi;
        }

        public String getImsi() {
            return imsi;
        }
    }

    /**
     * 对接的下游流量
     */
    public enum Media {
        Default(-1),
        Unknown(0),
        /**
         * bxmAdx协议
         */
        Bxm(1),
        /**
         * bxmSsp协议
         */
        Bxmssp(2),
        /**
         * 兜底入口
         */
        Backup(3),
        /**
         * 巨浪
         */
        Julang(4),
        /**
         * 第四范式
         */
        Paradigm(5),
        /**
         * 美数
         */
        Meishu(6),
        /**
         * wps
         */
        Wps(7),
        /**
         * 欢乐计步宝
         */
        Jishubao(8),
        /**
         * 百搜视频
         */
        Baisou(9),
        /**
         * 漫星
         */
        Manxing(10),
        /**
         * 光音ssp
         */
        Guangyin(11),
        /**
         * 联道ssp
         */
        Liandao(12),
        /**
         * ssp2345
         */
        Ssp2345(13),
        /**
         * 博创
         */
        Bochuang(14),
        /**
         * 小迈
         */
        Xiaomai(15),
        /**
         * 壹恩
         */
        Yien(16),
        /**
         * 聚告
         */
        Jugao(17),
        /**
         * 益起
         */
        Yiqi(18),
        /**
         * 俱脉
         */
        Jumai(19),
        /**
         * 触网
         */
        Chuwang(20),
        /**
         * 魔力果
         */
        Moliguo(21),
        /**
         * 沃氪
         */
        Woke(22),
        /**
         * 金岩石
         */
        Kingstone(23),
        /**
         * 佳量
         */
        Jialiang(24),
        /**
         * 盛通
         */
        Shengtong(25),
        /**
         * 泰然
         */
        Tairan(26),
        /**
         * 一玄
         */
        Yixuan(27),
        /**
         * 自旋
         */
        Zixuan(28),
        /**
         * 曝量
         */
        Puliang(29),
        /**
         * 壹道
         */
        Yidao(30),
        /**
         * 快雅
         */
        Kuaiya(31),
        /**
         * inmobi
         */
        Inmobi(32),
        /**
         * 新边界
         */
        Xinbianjie(33),
        /**
         * 新知
         */
        Xinzhi(34),
        /**
         * 中青看点
         */
        Zhongqing(35),
        /**
         * 万维
         */
        Wanwei(36),
        /**
         * Sigmob
         */
        Sigmob(37),
        /**
         * 数川
         */
        Shuchuan(38),
        /**
         * soul
         */
        Soul(39),
        /**
         * 百寻
         */
        Baixun(40),
        /**
         * 森乐
         */
        Senle(41),
        /**
         * 百度
         */
        Bes(42),
        /**
         * Topon
         */
        Topon(43),
        /**
         * 阅客
         */
        Yueke(44),
        /**
         * 洋扬
         */
        Yangy(45),
        /**
         * 新数
         */
        Xinshu(46),
        /**
         * 京盟
         */
        Jingmeng(47),
        /**
         * 沅思
         */
        Yuansi(48),
        /**
         * 趣头条
         */
        Qutoutiao(49),
        /**
         * 中关
         */
        Zhongguan(50),
        /**
         * 因代克斯
         */
        Index(51),
        /**
         * 掌阅
         */
        Zhangyue(52),
        /**
         * 芒果
         */
        Mangguo(55),
        /**
         * cashcat
         */
        Cashcat(58),
        /**
         * 传广
         */
        Chuanguang(66),
        /**
         * oppo
         */
        Oppo(76),
        ;
        private final int id;

        Media(int id) {
            this.id = id;
        }

        public static Media of(int id) {
            Media[] values = values();
            for (Media value : values) {
                if (id == value.id) {
                    return value;
                }
            }
            return Unknown;
        }

        public int getId() {
            return id;
        }
    }

    /**
     * 竞价支持的计费模式
     */
    public interface BidModel {
        int SUPPORT_CPM = 1;
        int SUPPORT_CPC = 2;
        int CTR = 3;
    }
    /**
     * 广告计费模式
     */
    public interface ChargeType {
        int CPM = 1;
        int CPC = 2;
    }

    /**
     * 由bxm替换赢价的媒体
     *
     * @param mediaId
     * @return
     */
    public static boolean needReplacePrice(String mediaId) {
        if (StringUtils.isNotEmpty(mediaId)) {
            Media media = Media.of(Integer.parseInt(mediaId));
            switch (media) {
                case Julang:
                case Baisou:
                case Moliguo:
                case Woke:
                case Kingstone:
                case Tairan:
                case Zixuan:
                case Puliang:
                case Xinbianjie:
                case Chuanguang:
                    return true;
                default:
                    return false;
            }
        }
        return false;
    }


    /**
     * 结算方式：1分成，2固价，3实时竞价
     */
    public enum SettleType {

        /**
         * 分成
         */
        DIVIDE_INTO(1, "分成"),
        /**
         * 定价
         */
        RTB(2, "固价"),
        /**
         * 实时竞价
         */
        REAL_TIME_RTB(3, "实时竞价"),
        ;

        private Integer type;
        private String name;

        SettleType(Integer type, String name) {
            this.type = type;
            this.name = name;
        }

        public Integer getType() {
            return type;
        }

        public String getName() {
            return name;
        }

        public static SettleType get(Integer type) {
            if (null == type) {
                return null;
            }
            for (SettleType anEnum : values()) {
                if (anEnum.getType().equals(type)) {
                    return anEnum;
                }
            }
            return null;
        }
    }

    /**
     * 广告位接入方式
     */
    public interface DockingMethodType {
        int API = 1;
        int SDK = 2;
    }

    /**
     * 1:最高价成交，2:第二高价成交
     */
    public interface At {
        int FIRST = 1;
        int SECOND = 2;
    }

    /**
     * Encryption Model 赢价加密模式 0-未加密，1-BXM默认支持的加密模式AES（详见ADX文档）,2-客制化（流量方自己的加密模式）
     */
    public interface EncryptionModel {
        int UNENCRYPTED = 0;
        int AES = 1;
        int CUSTOMIZE = 2;
    }

    /**
     * No Bid Response
     * 不参与竞价的原因
     */
    public interface Nbr {
        /**
         * 屏蔽设备号
         */
        int BLOCK_DEVICE = 40001;
    }

    /**
     * 设备类型
     */
    public interface DeviceType {
        int UNKNOWN = 0;
        /**
         * 手机
         */
        int PHONE = 1;
        /**
         * 平板
         */
        int TABLET = 2;
    }

    /**
     *  插件自定义参数
     */
    public interface PluginParam {
        /**
         * 媒体ID
         */
        String MEDIA_ID = "id";
        /**
         * 变现猫ADX加密模式
         * @see EncryptionModel
         */
        String BXM_ENCRYPT_MODEL = "encm";
        /**
         * 第三方（媒体/DSP）赢价宏参
         */
        String MACRO_WIN_PRICE = "mwp";
    }

    /**
     * 流量分配出价类型
     */
    public interface DispatcherAvgType {
        /**
         * 固价
         */
        int FIXED = 0;
        /**
         * 不设置
         */
        int NONE = 1;
        /**
         * 固价+折扣
         */
        int FIXED_DISCOUNT = 2;

        /**
         * 按广告主出价
         */
        int BID_BY_DSP = 3;
    }

    /**
     * 流量分配赢价类型
     */
    public interface DispatcherDspWinType {
        /**
         * 固价
         */
        int FIXED = 2;
        /**
         * 按媒体
         */
        int MEDIA_BASE = 4;
    }

    public enum Format {

        /**
         * XML
         */
        Xml,

        /**
         * JSON
         */
        Json,

        /**
         * Google protobuf
         */
        Protobuf,

        /**
         * Tag Length Value
         */
        TLV
    }

    /**
     * 经纬度坐标系
     */
    public interface GeoType {
        int GCJ02 = 1;
        int WGS84 = 2;
        int BD09 = 3;
        int IP = 4;
    }

    /**
     * 加密形式
     */
    public interface EnType {
        /**
         * 未加密
         */
        int  UN_EN = 1;
        int MD5 = 2;

    }
}
