package com.bxm.adx.common;

import com.bxm.adx.common.utils.DateUtils;
import lombok.Data;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * 通过埋点事件单位时间的次数控制是否请求dsp
 *
 * @author fgf
 * @date 2022/11/21
 **/
@Data
public class DotEventControlProperties {

    private String id;

    private String sspPositionId;
    private String dspId;
    private String dspPositionId;

    /**
     * 控制的埋点事件
     */
    private int mt = OpenlogConstants.Mt.IMP_MT;
    /**
     * 开始时间
     */
    private String startDateTime;
    /**
     * 结束时间
     */
    private String endDateTime;
    /**
     * 时间单位
     */
    private TimeUnit timeUnit = TimeUnit.MINUTES;
    /**
     * 时间间隔
     * 配合时间单位即：每10分钟控制达到曝光数后不请求dsp
     */
    private Integer timeInterval = 10;
    /**
     * 总共控制的数量
     */
    private long total;
    /**
     * 控制类型
     * 0：如果当下时间段内曝光数没有达到限制，啥也不做～
     * 1：如果当下时间段内曝光数没有达到限制，就加到下个时间段
     */
    private byte model = 1;

    public DotEventControlProperties() {
    }

    private LocalDateTime start;
    private LocalDateTime end;

    public void setStartDateTime(String startDateTime) {
        this.startDateTime = startDateTime;
        this.start = DateUtils.convertLocalDateTime(startDateTime);
    }

    public void setEndDateTime(String endDateTime) {
        this.endDateTime = endDateTime;
        this.end = DateUtils.convertLocalDateTime(endDateTime);
    }

    public long getIntervalLimit(int exposedCount) {
        long limit = 0;
        if (end.isAfter(start)) {
            LocalDateTime now = LocalDateTime.now();
            Duration duration = null;
            if (now.isBefore(start)) {
                duration = Duration.between(start, end);
            } else {
                duration = Duration.between(now, end);
            }
            long minutes = duration.toMinutes();
            long section = (int) Math.ceil((double) minutes / timeInterval);
            limit = (total - exposedCount) / section;
        }
        return limit;
    }

    public String getSectionId(LocalDateTime now) {
        Duration duration = Duration.between(start, now);
        long minutes = duration.toMinutes();
        long section = (int) Math.ceil((double) minutes / timeInterval);
        return String.valueOf(section);
    }
}
