package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.DeviceCrowdPackageJedisProperties;
import com.bxm.adx.common.buy.dispatcher.filter.BlackCrowdPackageFilter;
import com.bxm.adx.common.buy.dispatcher.filter.WhiteCrowdPackageFilter;
import com.bxm.adx.common.limiter.DefaultInsertExpireHandler;
import com.bxm.adx.common.limiter.DefaultDeleteExpiredHandler;
import com.bxm.adx.common.limiter.DeleteExpiredHandler;
import com.bxm.adx.common.limiter.InsertExpireHandler;
import com.bxm.adx.common.market.nbr.BlockDeviceHandler;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

/**
 * 设备人群包定向redis
 *
 * @author fgf
 * @date 2023-04-03
 * @since 1.0
 */
@ConditionalOnProperty(prefix = "adx", value = "enable-crowd", havingValue = "true")
@EnableConfigurationProperties(DeviceCrowdPackageJedisProperties.class)
public class DeviceCrowdPackageJedisAutoConfiguration {

    private final DeviceCrowdPackageJedisProperties properties;

    public DeviceCrowdPackageJedisAutoConfiguration(DeviceCrowdPackageJedisProperties properties) {
        this.properties = properties;
    }

    @Bean(name = "crowdPackJedisPool")
    public JedisPool crowdPackJedisPool() {
        return new JedisPool(properties, properties.getHost(), properties.getPort(), properties.getTimeout(), properties.getPassword(), properties.getDatabase());
    }

    @Bean(name = "crowdPackFetcher")
    public JedisFetcher crowdPackFetcher(@Qualifier("crowdPackJedisPool") JedisPool crowdPackJedisPool) {
        return new JedisFetcher(crowdPackJedisPool);
    }

    @Bean(name = "crowdPackUpdater")
    public JedisUpdater crowdPackUpdater(@Qualifier("crowdPackJedisPool") JedisPool crowdPackJedisPool) {
        return new JedisUpdater(crowdPackJedisPool);
    }

    @Bean(name = "crowdPackCounter")
    public JedisCounter crowdPackCounter(@Qualifier("crowdPackJedisPool") JedisPool crowdPackJedisPool) {
        return new JedisCounter(crowdPackJedisPool);
    }

    @Bean("deleteExpiredDeviceCrowdPackageHandler")
    public DeleteExpiredHandler deleteExpiredDeviceCrowdPackageHandler(@Qualifier("crowdPackUpdater") Updater updater) {
        return new DefaultDeleteExpiredHandler(updater);
    }

    @Bean("insertExpireDeviceCrowdPackageHandler")
    public InsertExpireHandler insertExpireDeviceCrowdPackageHandler(@Qualifier("crowdPackUpdater") Updater updater, @Qualifier("crowdPackFetcher") Fetcher fetcher) {
        return new DefaultInsertExpireHandler(updater, fetcher);
    }

    @Bean
    public WhiteCrowdPackageFilter whiteCrowdPackageFilter(@Qualifier("crowdPackFetcher") Fetcher fetcher,
                                                      @Qualifier("deleteExpiredDeviceCrowdPackageHandler") DeleteExpiredHandler deleteExpiredHandler) {
        return new WhiteCrowdPackageFilter(fetcher, deleteExpiredHandler);
    }

    @Bean
    public BlackCrowdPackageFilter blackCrowdPackageFilter(@Qualifier("crowdPackFetcher") Fetcher fetcher,
                                                           @Qualifier("deleteExpiredDeviceCrowdPackageHandler") DeleteExpiredHandler deleteExpiredHandler) {
        return new BlackCrowdPackageFilter(fetcher, deleteExpiredHandler);
    }

    @Bean
    public BlockDeviceHandler blockDeviceHandler(@Qualifier("insertExpireDeviceCrowdPackageHandler") InsertExpireHandler insertExpireHandler) {
        return new BlockDeviceHandler(insertExpireHandler, properties);
    }
}
