package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.ServerReportProperties;
import com.bxm.adx.common.market.monitor.ServerReportHandler;
import com.bxm.adx.common.openlog.listener.external.AdClickForServerReportEventListener;
import com.bxm.adx.common.openlog.listener.external.AdShowForServerReportEventListener;
import com.bxm.adx.common.report.DefaultHttpClientReportClient;
import com.bxm.adx.common.report.DspWinPriceHandler;
import com.bxm.adx.common.report.ReportClient;
import com.bxm.adx.common.report.ServerReportService;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.NamedThreadFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author fgf
 * @date 2023/4/19
 **/
@ConditionalOnProperty(prefix = "adx.server-report", value = "enable", havingValue = "true")
@EnableConfigurationProperties(ServerReportProperties.class)
public class ServerReportAutoConfiguration {
    private final ServerReportProperties serverReportProperties;

    public ServerReportAutoConfiguration(ServerReportProperties serverReportProperties) {
        this.serverReportProperties = serverReportProperties;
    }

    @Bean
    public ReportClient reportClient() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 10, 0, TimeUnit.SECONDS,
                new LinkedBlockingQueue<>(1000), new NamedThreadFactory("report-client"));
        return DefaultHttpClientReportClient.builder().setExecutor(executor).build();
    }

    @Bean
    public ServerReportService serverReportService(JedisPool jedisPool, ReportClient reportClient, AdxProperties properties,
                                                   EventPark eventPark, DspWinPriceHandler dspWinPriceHandler) {
        return new ServerReportService(serverReportProperties, jedisPool, reportClient, properties, eventPark, dspWinPriceHandler);
    }

    @Bean
    public ServerReportHandler serverReportHandler(ServerReportService serverReportService) {
        return new ServerReportHandler(serverReportService);
    }

    @Bean
    public AdShowForServerReportEventListener adShowForServerReportEventListener(ServerReportService serverReportService) {
        return new AdShowForServerReportEventListener(serverReportService);
    }

    @Bean
    public AdClickForServerReportEventListener adClickForServerReportEventListener(ServerReportService serverReportService) {
        return new AdClickForServerReportEventListener(serverReportService);
    }
}
