package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspCaching;
import com.bxm.adx.common.buy.dsp.DspChangedEvent;
import com.bxm.adx.common.caching.sync.DataSyncHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

/**
 * @author fgf
 * @date 2022/12/19
 **/
@Slf4j
@Configuration
public class DspDataSyncHandler implements DataSyncHandler, ApplicationContextAware {
    private final DspCaching dspCaching;
    private ApplicationContext applicationContext;

    public DspDataSyncHandler(DspCaching dspCaching) {
        this.dspCaching = dspCaching;
    }

    @Override
    public Class<?> getClazz() {
        return Dsp.class;
    }

    @Override
    public Object set(String key, Object object) {
        if (!(object instanceof Dsp)) {
            log.warn("object {} not support", object);
            return object;
        }
        Dsp dsp = (Dsp) object;
        if (dsp.isForbidden()) {
            dspCaching.del(dsp.getDspCode());
        } else {
            dspCaching.set(dsp.getDspCode(), dsp);
            //更新dsp对应的httpclient
            applicationContext.publishEvent(new DspChangedEvent(this, dsp));
        }
        return object;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
