package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.caching.sync.DataSyncHandler;
import com.bxm.adx.common.creative.review.ReviewCreative;
import com.bxm.adx.common.creative.review.ReviewCreativeCaching;
import com.bxm.mccms.facade.model.pushable.CreativeReviewCacheVO;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

/**
 * @author fgf
 * @date 2022/12/7
 **/
@Slf4j
@Configuration
public class ReviewCreativeDataSyncHandler implements DataSyncHandler {
    private final ReviewCreativeCaching reviewCreativeCaching;

    public ReviewCreativeDataSyncHandler(ReviewCreativeCaching reviewCreativeCaching) {
        this.reviewCreativeCaching = reviewCreativeCaching;
    }

    @Override
    public Class<?> getClazz() {
        return CreativeReviewCacheVO.class;
    }

    @Override
    public Object set(String key, Object object) {
        CreativeReviewCacheVO creativeReviewCacheVO = (CreativeReviewCacheVO) object;
        ReviewCreative reviewCreative = new ReviewCreative();
        BeanUtils.copyProperties(creativeReviewCacheVO, reviewCreative);
        reviewCreativeCaching.set(String.valueOf(reviewCreative.getId()), reviewCreative);
        log.info("reviewCreativeSet data : {}", JsonHelper.convert(reviewCreative));
        return object;
    }
}
