package com.bxm.adx.common.filter;

import com.bxm.adx.common.rule.LimitRule;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.position.Position;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * @author fgf
 * @date 2023/3/20
 **/
@Slf4j
//@Configuration
public class PositionLimitFilter extends AbstractPositionFilter {
    @Override
    protected List<String> doFilter(MarketOrders marketOrders) {
        List<Position> positions = marketOrders.getPositions();
        List<String> removes = Lists.newArrayList();
        positions.forEach(
                position -> {
                    Rule rule = position.getFrequencyControl();
                    if (Objects.isNull(rule)) {
                        return;
                    }
                    LimitRule limitRule = new LimitRule(rule);
                    Set<LimitConfig> configs = limitRule.getSet();
                    if (CollectionUtils.isEmpty(configs)) {
                        return;
                    }


                }
        );
        return removes;
    }

    @Override
    public int order() {
        return 0;
    }
}
