package com.bxm.adx.common.ingetration;

import com.bxm.adx.facade.constant.Constants;
import com.bxm.adx.facade.model.task.TaskCounter;
import com.bxm.adx.facade.model.task.TaskInfo;
import com.bxm.adx.facade.model.task.TaskInfoRequest;

import java.util.List;

/**
 * @author allen
 * @date 2020-11-17
 * @since 1.0
 */
public interface TaskServiceIntegration {

    /**
     * 获取任务信息<br/>
     *
     * @param request
     * @return
     */
    TaskInfo getTask(TaskInfoRequest request);

    /**
     * 获取任务信息列表<br/>
     *
     * @param request
     * @return
     */
    List<TaskInfo> getTasks(TaskInfoRequest request);

    /**
     * 批量获取任务统计信息<br/>
     *
     * @param idsStr 主键字符串，逗号分隔{@link Constants.SPLIT_COMMA}
     * @return
     */
    List<TaskCounter> getByIds(String idsStr);
}
