package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;

/**
 * app包名出价过滤
 * @author jingyu.li
 * @date 2024-06-06
 */
@Slf4j
@Configuration
public class AppPackageDispatcherPriceConfigFilter implements DispatcherPriceConfigFilter{

    @Override
    public int getOrder() {
        return 20;
    }

    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        //根据包名匹配白名单策略，如果是白名单 并且 不在白名单里的删除，如果是黑名单 并且 在黑名单里的删除
        String bundle = null;
        try {
            BidRequest bidRequest = attribute.getBidRequest();
            App app = bidRequest.getApp();
            bundle = app.getBundle();
        } catch (Exception e) {
            log.warn("adid:{},bidId:{} getAppPackage exception :",bid.getAdid(),bid.getId(),e);
        }
        if (log.isDebugEnabled()) {
            log.debug(" adid:{},bidId:{},bundle:{}", bid.getAdid(),bid.getId(),bundle);
        }
        //过滤
        String finalBundle = bundle;
        priceConfigs.removeIf(config -> whetherHitOrNot(config,finalBundle));
    }

    /**
     * 根据包名判断是否需要排除当前出价配置
     * @return ture 排除  false 不排除
     */
    private boolean whetherHitOrNot(DispatcherPriceConfig config,String bundle) {
        if (config.getAppPkgFilterMode() == null) {
            return false;
        }
        //白名单 包名不在配置列表里排除
        if (DispatcherPriceConfig.FILTER_MODEL_WHITE == config.getAppPkgFilterMode()) {
            if (CollectionUtils.isEmpty(config.getAppPackageList())) {
                return true;
            }
            if (!config.getAppPackageList().contains(bundle)) {
                return true;
            }
        }
        //黑名单 包名在配置列表里排除
        if (DispatcherPriceConfig.FILTER_MODEL_BLACK == config.getAppPkgFilterMode()) {
            if (CollectionUtils.isEmpty(config.getAppPackageList())) {
                return false;
            }
            return config.getAppPackageList().contains(bundle);
        }
        return false;
    }
}
