package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.mccms.facade.enums.OfferSettle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * 固价+打折
 *
 * @author fgf
 * @date 2023/5/19
 **/
@Configuration
@Slf4j
public class DspAvgPriceDiscountOffer implements Offer {

    @Override
    public OfferResult offer(Bid bid, BidRequest request, Dispatcher dispatcher, DispatcherPriceConfig priceConfig) {
        String mediaSettle = dispatcher.getMediaSettle();
        int chargeType = AdxConstants.ChargeType.CPM;
        int budgetType = AdxConstants.ChargeType.CPM;
        if (Objects.nonNull(mediaSettle)) {
            if (OfferSettle.CPC.name().equalsIgnoreCase(mediaSettle)) {
                log.warn("warn cpc model");
                chargeType = AdxConstants.ChargeType.CPC;
                budgetType = AdxConstants.ChargeType.CPC;
            }
        }

        Integer bidModel = request.getBid_model();
        if (Objects.nonNull(bidModel)) {
            switch (bidModel) {
                case AdxConstants.BidModel.SUPPORT_CPC:
                    chargeType = AdxConstants.ChargeType.CPC;
                    budgetType = AdxConstants.ChargeType.CPC;
                    break;
            }
        }

        return OfferResult.builder()
                .chargeType(chargeType)
                .budgetType(budgetType)
                .offer(getOffer(dispatcher, bid, priceConfig))
                .build();
    }

    @Override
    public OfferType offerType() {
        return OfferType.Dsp_Avg_Price_Discount;
    }

    private BigDecimal getOffer(Dispatcher dispatcher, Bid bid, DispatcherPriceConfig bidPriceConfig) {
        if (Objects.nonNull(bidPriceConfig)) {
            BigDecimal dspCpmPrice = bidPriceConfig.getDspCpmPrice();
            if (Objects.nonNull(dspCpmPrice)) {
                return dspCpmPrice.movePointRight(2);
            }
        }
        log.error("dispatcher {} dsp-cpm empty", dispatcher.getId());
        return bid.getPrice();
    }
}
