package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * 固价
 *
 * @author fgf
 * @date 2023/1/10
 **/
@Slf4j
@Configuration
public class DspAvgPriceOffer implements Offer {

    @Override
    public OfferResult offer(Bid bid, BidRequest request, Dispatcher dispatcher, DispatcherPriceConfig priceConfig) {
        Integer bidModel = request.getBid_model();
        int chargeType = AdxConstants.ChargeType.CPM;
        int budgetType = AdxConstants.ChargeType.CPM;
        if (Objects.nonNull(bidModel)) {
            switch (bidModel) {
                case AdxConstants.BidModel.SUPPORT_CPC:
                    chargeType = AdxConstants.ChargeType.CPC;
                    budgetType = AdxConstants.ChargeType.CPC;
                    break;
            }
        }

        return OfferResult.builder()
                .chargeType(chargeType)
                .offer(getFixedPrice(dispatcher, priceConfig))
                .budgetType(budgetType)
                .build();
    }

    @Override
    public OfferType offerType() {
        return OfferType.Dsp_Avg_Price;
    }

    /**
     * 获取固价配置
     * 兼容老字段DspAvgPrice
     *
     * @param dispatcher
     * @return
     */
    private BigDecimal getFixedPrice(Dispatcher dispatcher, DispatcherPriceConfig dispatcherPriceConfig) {
        if (Objects.nonNull(dispatcherPriceConfig)) {
            BigDecimal mediaOfferPrice = dispatcherPriceConfig.getMediaOfferPrice();
            if (Objects.nonNull(mediaOfferPrice)) {
                return mediaOfferPrice.movePointRight(2);
            }
        }

        log.warn("dispatcher {} dsp-cpm empty", dispatcher.getId());
        return dispatcher.getDspAvgPrice().movePointRight(2);
    }
}
