package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointService;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.App;
import com.bxm.warcar.integration.pair.DefaultValue;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.integration.pair.Value;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;
import java.util.Set;

/**
 * 重构BidRequest中的App
 *
 * @author fgf
 * @date 2023/1/6
 **/
@Configuration
public class AppBuilder implements AdxBidRequestBuilder {
    private final AdvertPointService advertPointService;
    private final Pair pair;
    private final static String KEY = "adx.app.package.dsp.list";

    public AppBuilder(AdvertPointService advertPointService, Pair pair) {
        this.advertPointService = advertPointService;
        this.pair = pair;
    }

    @Override
    public void rebuildAdxBidRequest(BidRequest adxBidRequest, RequestBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getBuyerWrapper().getDispatcher();
        AdvertPoint advertPoint = advertPointService.getAdvertPointByDspId(dispatcher.getDspId().toString(), dispatcher.getDspAppid(), dispatcher.getDspPosid());
        App app = new App();
        if (Objects.nonNull(adxBidRequest.getApp())) {
            BeanUtils.copyProperties(adxBidRequest.getApp(), app);
        }

        app.setId(dispatcher.getDspAppid());
        setAppPackageName(app, dispatcher);

        if (Objects.nonNull(advertPoint)) {
            app.setVer(advertPoint.getVersion());
            app.setName(advertPoint.getAppName());
        }

        adxBidRequest.setApp(app);
    }

    private void setAppPackageName(App app, Dispatcher dispatcher) {
        Set<String> dspIds = pair.get(KEY).ofHashSet();
        if (CollectionUtils.isNotEmpty(dspIds)) {
          String dspId = String.valueOf(dispatcher.getDspId());
          if (dspIds.contains(dspId)) {
              return;
          }
        }
        if (StringUtils.isNotEmpty(dispatcher.getAppPackageName())) {
            app.setBundle(dispatcher.getAppPackageName());
        }
    }
}
