package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

/**
 * @author fgf
 * @date 2023/1/9
 **/
@Slf4j
@Configuration
public class BidBuilder implements AdxBidResponseBuilder {

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        BidRequest adxRequest = attribute.getAdxRequest();
        Impression impression = adxRequest.getImps().iterator().next();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                if (StringUtils.isEmpty(bid.getId())) {
                    bid.setId(RandomStringUtils.randomAlphabetic(8));
                }
                if (StringUtils.isEmpty(bid.getAdid())) {
                    bid.setAdid(RandomStringUtils.randomAlphanumeric(5));
                }
                if (StringUtils.isEmpty(bid.getTag_id())) {
                    bid.setTag_id(impression.getTag_id());
                }
                if (StringUtils.isEmpty(bid.getCreate_id())) {
                    bid.setCreate_id(RandomStringUtils.randomAlphabetic(6));
                }
                Integer chargeType = Optional.ofNullable(bid.getCharge_type()).orElse(AdxConstants.ChargeType.CPM);
                bid.setCharge_type(chargeType);
                bid.setDsp_charge_type(chargeType);
                Integer budgetType = Optional.ofNullable(bid.getBudget_type()).orElse(AdxConstants.ChargeType.CPM);
                bid.setBudget_type(budgetType);
                bid.setDsp_budget_type(budgetType);
                //记录dsp出价
                switch (budgetType) {
                    case AdxConstants.ChargeType.CPM:
                        bid.setDsp_price(new BigDecimal(bid.getPrice().toString()));
                        break;
                    case AdxConstants.ChargeType.CPC:
                        bid.setDsp_price(new BigDecimal(bid.getBid().toString()));
                        break;
                }

                bid.setDsp_appid(dispatcher.getDspAppid());
                bid.setDsp_posid(dispatcher.getDspPosid());
                bid.setDspId(dispatcher.getDspId());
                if (Objects.isNull(bid.getImp_id())) {
                    bid.setImp_id(impression.getId());
                }
                if (Objects.isNull(bid.getType())) {
                    Integer type = Optional.ofNullable(AdxConstants.Type.getTypeByImpType(impression.getImp_type()))
                            .orElse(AdxConstants.Type.IMAGE.getType());
                    bid.setType(type);
                }
                //设置bid对应的价格配置，注意此类的顺序
                String dpcId = bid.getDpc_id();
                if (StringUtils.isNotEmpty(dpcId)) {
                    Optional<DispatcherPriceConfig> optional = dispatcher.getDispatcherPriceConfigs().stream().filter(priceConfig ->
                            priceConfig.getPriceModeId().toString().equals(dpcId)).findFirst();
                    if (optional.isPresent()) {
                        attribute.putBidPriceConfig(bid, optional.get());
                    } else {
                        log.warn("dispatcher {} dpcid {} config is null", dispatcher.getId(), dpcId);
                    }
                }
            }
        }
    }
}
