package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.AdxBidEvent;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.ArrayList;
import java.util.List;

/**
 * @author fgf
 * @date 2022/6/1
 **/
@Configuration
public class DotAdxBidEventListener implements EventListener<AdxBidEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DotAdxBidEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdxBidEvent event) {
        if (Math.abs(event.getSspRequest().getId().hashCode() % 100) >= properties.getDotSimplingPercent()) {
            return;
        }
        MultiValueMap<String, String> customizeParams = buildCustomizeParams(event.getAdxResponse());
        String url = properties.getOpenLog().create(true, OpenlogConstants.Mt.ADX_RESPONSE_MT, customizeParams, OpenlogConstants.WITHOUT_MACROS_INNER);
        Long dspId = event.getAdxResponse().getSeat_bid().iterator().next().getDspId();
        BuildAttribute attribute = new BuildAttribute(OpenlogConstants.Mt.ADX_RESPONSE_MT)
                .setDspId(dspId)
                .setSspRequest(event.getSspRequest())
                .setAdxResponse(event.getAdxResponse())
                .setStrategyId(event.getAdxResponse().getSeat_bid().iterator().next().getStrategyId());
        url = macrosHandler.replaceAll(url, attribute);
        openLogClient.asyncRequest(url);
    }

    /**
     * 构建客制化埋点参数
     * @param bidResponse
     * @return
     */
    private MultiValueMap<String, String> buildCustomizeParams(BidResponse bidResponse) {
        MultiValueMap<String, String> customizeParams = new LinkedMultiValueMap<>();
        List<DotAdxBidEventListener.Creative> creatives = getCreatives(bidResponse);
        String value = UrlHelper.urlEncode(JsonHelper.convert(creatives));
        customizeParams.add(OpenlogConstants.MacrosCustomizeParams.BID_CREATIVES, value);
        return customizeParams;
    }

    /**
     * 参竞广告详情
     * @param bidResponse
     * @return
     */
    private List<DotAdxBidEventListener.Creative> getCreatives(BidResponse bidResponse) {
        List<DotAdxBidEventListener.Creative> creatives = new ArrayList<>();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                DotAdxBidEventListener.Creative creative = new DotAdxBidEventListener.Creative()
                        .setCreativeId(bid.getCreate_id())
                        .setTicketId(bid.getAdid())
                        .setBdgtyp(bid.getBudget_type())
                        .setPrice(bid.getBudget_type() == AdxConstants.ChargeType.CPM ? bid.getPrice().toString() : bid.getBid().toString())
                        .setTid(bid.getTask_id())
                        .setDpcid(bid.getDpc_id())
                        .setDspId(seatBid.getDspId())
                        .setDappid(bid.getDsp_appid())
                        .setDtagid(bid.getTag_id())
                        .setConfigid(seatBid.getConfigId())
                        .setUsl(bid.getUser_score_level())
                        ;
                creatives.add(creative);
            }
        }
        return creatives;
    }

    @Data
    @Accessors(chain = true)
    private static class Creative {
        private String creativeId;
        private String ticketId;
        private String price;
        private String tid;
        private String dpcid;
        private Integer bdgtyp;
        private Long dspId;
        private String dappid;
        private String dtagid;
        private Long configid;
        private Integer usl;
    }
}
