package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.MediaRequestEvent;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.request.Geo;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.Objects;

/**
 * @author fgf
 * @date 2022/6/1
 **/
@Configuration
public class DotMediaRequestEventListener implements EventListener<MediaRequestEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;
    private final double EPSILON = 0.01D;

    public DotMediaRequestEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(MediaRequestEvent event) {
        if (Math.abs(event.getSspRequest().getId().hashCode() % 100) >= properties.getDotSimplingPercent()) {
            return;
        }
        String url = properties.getOpenLog().create(true, OpenlogConstants.Mt.MEDIA_REQUEST_MT, customizeParams(event), "dspid", "chgtypm", "chgtypd");
        BuildAttribute attribute = new BuildAttribute(OpenlogConstants.Mt.MEDIA_REQUEST_MT).setSspRequest(event.getSspRequest());
        url = macrosHandler.replaceAll(url, attribute);
        openLogClient.asyncRequest(url);
    }

    private MultiValueMap<String, String> customizeParams(MediaRequestEvent event) {
        MultiValueMap<String, String> customizeParams = new LinkedMultiValueMap<>();

        BidRequest request = event.getSspRequest();
        Geo geo = request.getGeo();
        if (Objects.nonNull(geo)) {
            Double lat = geo.getLat();
            Double lon = geo.getLon();
            if (Objects.nonNull(lat) && Objects.nonNull(lon)) {
                if (isZero(lat) || isZero(lon)) {
                    return null;
                }
                customizeParams.add("geo", StringUtils.join(new String[]{String.format("%.2f", lat), String.format("%.2f", lon)}, ","));
            }
        }
//        App app = request.getApp();
//        if (Objects.nonNull(app)) {
//            String name = app.getName();
//            if (StringUtils.isNotBlank(name)) {
//                customizeParams.add("appname", name);
//            }
//        }
        return customizeParams;
    }

    private boolean isZero(double value) {
        return Math.abs(value) < EPSILON;
    }
}
