package com.bxm.adx.common.rule;

import com.google.common.collect.Sets;
import lombok.Builder;
import lombok.Data;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

/**
 * @author fgf
 * @date 2023/3/22
 **/
public class WhiteAndBlackRule {
    private final static String TYPE_SPLIT = "&";
    private final static String SPLIT = ",";

    private final Rule rule;
    private final String typeSeparatorChars;
    private final String separatorChars;

    public WhiteAndBlackRule(Rule rule) {
        this(rule, TYPE_SPLIT, SPLIT);
    }

    public WhiteAndBlackRule(Rule rule, String typeSeparatorChars, String separatorChars) {
        this.rule = rule;
        this.typeSeparatorChars = typeSeparatorChars;
        this.separatorChars = separatorChars;
    }

    public WhiteAndBlack getWhiteAndBlack() {
        String ruleVal = rule.ruleValue;
        if (StringUtils.isBlank(ruleVal)) {
            return null;
        }
        String[] array = ruleVal.split(typeSeparatorChars);
        if (ArrayUtils.isEmpty(array) || array.length < 1) {
            return null;
        }
        WhiteAndBlack whiteAndBlack = new WhiteAndBlack();
        String white = array[0];
        if (StringUtils.isNotBlank(white)) {
            whiteAndBlack.getWhite().addAll(Sets.newHashSet(white.split(separatorChars)));
        }
        String black = array.length > 1 ? array[1] : null;
        if (StringUtils.isNotBlank(black)) {
            whiteAndBlack.getBlack().addAll(Sets.newHashSet(black.split(separatorChars)));
        }
        return whiteAndBlack;
    }


    @Data
    public static class WhiteAndBlack {
        private Set<String> white = Sets.newHashSet();
        private Set<String> black = Sets.newHashSet();

        public Set<String> getAll() {
            Set<String> all = new HashSet<>();
            all.addAll(white);
            all.addAll(black);
            return all;
        }
    }
}
