package com.bxm.adx.common.sell.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class Bid implements Serializable {
    /**
     * bidid
     */
    private String id;
    /**
     * 广告id
     */
    private String adid;
    /**
     * 素材ID,对于需要审核的渠道来说，这是提交给渠道审核时的ID
     */
    private String create_id;
    /**
     * 对应 request#Impression 对象的 ID 属性
     */
    private String imp_id;
    /**
     * CPM出价，每个曝光单元中的实际竞价价格，单位是分/每千次曝光,最多两位⼩数。
     */
    private BigDecimal price;
    /**
     * ⼴告⾏业分类
     */
    private List<String> cat;
    /**
     * ⼴告创意类型。
     * 1、原生，2、图片，3、视频，4、文字
     */
    private Integer type;
    /**
     * ⽂件⽬标类型。
     * <pre>
     * 0、未知
     * 1、png
     * 2、jpg
     * 3、gif
     * 4、flv
     * 5、MP4
     * </pre>
     */
    private Integer f_type;
    /**
     * 点击⽬标类型。
     * <pre>
     * 0、未知
     * 1、打开网页
     * 2、下载APP
     * 3、到App Store下载（iOS）
     * 4、发送短信
     * 5、拨打电话
     * 6、用 WebView 打开网页
     * 7、打开为详情页（Android）
     * 8、应用内下载且支持触发URL（Android）
     * 9、DeepLink 跳转
     * </pre>
     */
    private Integer c_type;
    /**
     * 点击后下载IOSAPP的包名，当ctype=3时⽣效
     */
    private String bundle;
    /**
     * 点击后下载APP的apk名，当ctype=2时⽣效
     */
    private String apk_name;
    /**
     * 应⽤版本号
     */
    private String app_ver;
    /**
     * ⼴告主检查主域名或顶级域名（同⼀个项⽬具有相同公共的 adomain）
     */
    @Deprecated
    private String a_domain;
    /**
     * ⼴告的合同号，若该字段与 request 中的 deal_ids 匹配，且返
     * 回的 bid:creaive_id 对应的⼴告主 id 是合同中约定的⼴告主id，
     * 表示参加PD竞价；若该字段与请求 deal_ids 不⼀致，⼴告会被过滤；
     * 若为 空，表示参加普通竞价。
     */
    @Deprecated
    private String deal_id;
    private Integer w;
    private Integer h;
    /**
     * Campaign id
     */
    @Deprecated
    private String cid;
    @Deprecated
    private String source_url;
    /**
     * Deeplink跳转地址，当ctype=9,deep_link_url必填
     *
     * @see #c_type
     */
    private String deep_link_url;
    /**
     * DSP⼴告曝光监测信息
     */
    private List<ImpMonitor> imp_monitors;
    /**
     * DSP ⼴告点击跳转地址,点击地址宏如下
     */
    private String click_through_url;
    /**
     * DSP⼴告点击监测信息
     */
    private List<ClickMonitor> click_monitors;
    /**
     * ⼴告赢价信息
     */
    @Deprecated
    private WinNotice win_notice;
    /**
     * 原⽣（信息流）⼴告对象创意返回信息。
     */
    @JsonProperty(value = "native")
    @JSONField(name = "native")
    private Native a_native;
    /**
     * 保留字段
     */
    private String ext;
    /**
     * APP监测信息， ctype=2或3，建议填写
     */
    private AppMonitor app_monitor;
    /**
     * ⼴告位id
     */
    @JSONField(serialize = false)
    private String tag_id;
    @JSONField(serialize = false)
    private String price_str;

    /**
     * 内部场景dsp用的活动ID/场景id
     */
    private String act_id;
    /**
     * 内部场景dsp用的活动ID/场景id
     */
    private String scene;

    /**
     * 展示标题栏:0不显示，1显示
     */
    private Integer show_title_bar;
    @JsonProperty(value = "dp_monitor")
    @JSONField(name = "dp_monitor")
    private DpMonitor dpMonitor;

    /**
     * 曝光、点击失败情况下需要处理的数据。
     */
    private Fail fail;
    /**
     * 场景dsp 互动活动类型下的广告id
     */
    private Long stid;

    public String getPrice_str() {
        if (StringUtils.isEmpty(price_str)) {
            if (Objects.nonNull(price)) {
                return price.toString();
            }
        }
        return price_str;
    }

    /**
     * 下载的app信息 (from bxm-pangu)
     */
    private DownloadInfo download_info;

    /**
     * app下载地址
     */
    private String app_download_url;
    //    @JsonIgnore
    @JSONField(serialize = false)
    /**
     * dsp侧appid
     */
    private String dsp_appid;

    /**
     * dsp侧posid
     */
    @JSONField(serialize = false)
    private String dsp_posid;

    //    @JsonIgnore
    @JSONField(serialize = false)
    /**
     * dsp广告出价
     */
    private BigDecimal dsp_price;

    /**
     * dsp赢价
     */
    @JSONField(serialize = false)
    private BigDecimal dspWinPrice;

    /**
     * 计费模式
     */
    private Integer cost_mode;

    /**
     * 包含点击监测的点击地址 302
     */
    private String click_through_url_302;
    /**
     * 微信小程序原始id，(支持微信小程序唤起时此字段才有效，该字段有值时同跳转至小程序，跳失败时调用click_through_url)。
     */
    private String mini_app_name;
    /**
     * 拉起小程序页面的可带参路径
     */
    private String mini_app_path;

    /**
     * adx自定义素材id
     */
    @JSONField(serialize = false)
    private String adxCreateId;
    /**
     * 计费类型（1:CPM,2:CPC）
     */
    private Integer charge_type;

    /**
     * dsp计费类型（1:CPM,2:CPC）
     */
    @JSONField(serialize = false)
    private Integer dsp_charge_type;

    @JSONField(serialize = false)
    private Long dspId;
    /**
     * CPC出价，单位是分， 分/每次点击，支持两位小数
     */
    private BigDecimal bid;
    /**
     * 参竞失败上报地址
     */
    private String fail_url;
    /**
     * 竞价成功上报地址
     */
    private String nurl;
    /**
     * iOS唤起通⽤链接
     */
    private String universal_link;
    /**
     * 投放产品
     */
    @JSONField(serialize = false)
    private String launchProduct;
    /**
     * 表示预算类型，cpc/cpm（1:CPM,2:CPC）
     */
    private Integer budget_type;
    /**
     * 表示dsp预算类型，cpc/cpm（1:CPM,2:CPC）
     */
    @JSONField(serialize = false)
    private Integer dsp_budget_type;
    /**
     * 任务id
     */
    @JSONField(serialize = false)
    private String task_id;
    /**
     * 启航用户质量分
     */
    @JSONField(serialize = false)
    private Integer user_score_level;
    /**
     * 流量分配价格配置id
     */
    @JSONField(serialize = false)
    private String dpc_id;
    /**
     * 广告主折扣后价格
     */
    @JSONField(serialize = false)
    private BigDecimal dsp_dis_price;
    /**
     * 广告主赢价计算方式 0：打折后dsp出价，1：按媒体成交价
     */
    @JSONField(serialize = false)
    private Integer adv_wpt;
    /**
     * 广告主成交价利润率
     */
    @JSONField(serialize = false)
    private BigDecimal adv_pm;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Bid bid = (Bid) o;
        return getId().equals(bid.getId()) && getAdid().equals(bid.getAdid());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getAdid());
    }
}
