/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter.task;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.service.common.sifter.task.TaskAbstractSifter;
import com.bxm.adx.service.common.sifter.task.TaskChainData;
import com.bxm.adx.service.common.sifter.task.TaskData;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.sifter.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class TaskCounterSifter
extends TaskAbstractSifter {
    private static final Logger log = LoggerFactory.getLogger(TaskCounterSifter.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public boolean filter(Context<TaskData> context) {
        this.fillCounter(context);
        if (this.filterTotal(context)) {
            return true;
        }
        return this.filterToday(context);
    }

    private boolean filterTotal(Context<TaskData> context) {
        TaskCache data = ((TaskData)context.getData()).getTaskCache();
        Map<String, String> map = ((TaskData)context.getData()).getMapCtTotal().get(data.getId());
        if (MapUtils.isEmpty(map)) {
            return false;
        }
        Long views = NumberUtils.toLong((String)map.get("VIEWS"), (long)0L);
        Long clicks = NumberUtils.toLong((String)map.get("CLICKS"), (long)0L);
        Long wakes = NumberUtils.toLong((String)map.get("WAKES"), (long)0L);
        if (null != data.getViewTotalLimit() && data.getViewTotalLimit() >= 1L && views >= data.getViewTotalLimit()) {
            super.addReason(context, "\u603b\u66dd\u5149\u9650\u5236");
            return true;
        }
        if (null != data.getClickTotalLimit() && data.getClickTotalLimit() >= 1L && clicks >= data.getClickTotalLimit()) {
            super.addReason(context, "\u603b\u70b9\u51fb\u9650\u5236");
            return true;
        }
        if (null != data.getWakeUpTotalLimit() && data.getWakeUpTotalLimit() >= 1L && wakes >= data.getWakeUpTotalLimit()) {
            super.addReason(context, "\u603b\u5524\u9192\u9650\u5236");
            return true;
        }
        return false;
    }

    private boolean filterToday(Context<TaskData> context) {
        TaskCache data = ((TaskData)context.getData()).getTaskCache();
        Map<String, String> map = ((TaskData)context.getData()).getMapCtToday().get(data.getId());
        if (MapUtils.isEmpty(map)) {
            return false;
        }
        Long views = NumberUtils.toLong((String)map.get("VIEWS"), (long)0L);
        Long clicks = NumberUtils.toLong((String)map.get("CLICKS"), (long)0L);
        Long wakes = NumberUtils.toLong((String)map.get("WAKES"), (long)0L);
        if (null != data.getViewDayLimit() && data.getViewDayLimit() >= 1L && views >= data.getViewDayLimit()) {
            super.addReason(context, "\u65e5\u66dd\u5149\u9650\u5236");
            return true;
        }
        if (null != data.getClickDayLimit() && data.getClickDayLimit() >= 1L && clicks >= data.getClickDayLimit()) {
            super.addReason(context, "\u65e5\u70b9\u51fb\u9650\u5236");
            return true;
        }
        if (null != data.getWakeUpDayLimit() && data.getWakeUpDayLimit() >= 1L && wakes >= data.getWakeUpDayLimit()) {
            super.addReason(context, "\u65e5\u5524\u9192\u9650\u5236");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCounter(Context<TaskData> context) {
        TaskData data = (TaskData)context.getData();
        if (Boolean.TRUE.equals(data.getFlagCounter())) {
            return;
        }
        List<Long> ids = super.getIds(context);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        TaskChainData chainData = ((TaskData)context.getData()).getChainData();
        HashMap<Long, Map<String, String>> mapCtTotal = new HashMap<Long, Map<String, String>>();
        HashMap<Long, Map<String, String>> mapCtToday = new HashMap<Long, Map<String, String>>();
        data.setFlagCounter(Boolean.TRUE);
        data.setMapCtTotal(mapCtTotal);
        data.setMapCtToday(mapCtToday);
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = null;
        HashMap<Long, Response<Map<String, String>>> mapCtTotalRs = new HashMap<Long, Response<Map<String, String>>>();
        HashMap<Long, Response<Map<String, String>>> mapCtTodayRs = new HashMap<Long, Response<Map<String, String>>>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (Long id : ids) {
                mapCtTotalRs.put(id, (Response<Map<String, String>>)pipeline.hgetAll(AdxKeyGenerator.Task.getCounter(id).generateKey()));
                mapCtTodayRs.put(id, (Response<Map<String, String>>)pipeline.hgetAll(AdxKeyGenerator.Task.getCounter(id, chainData.getTodayYmd()).generateKey()));
            }
            pipeline.syncAndReturnAll();
        }
        catch (Exception e) {
            log.error("fillCounter error: ids={},e={}", ids, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        this.fillCounter(mapCtTotal, mapCtToday, mapCtTotalRs, mapCtTodayRs);
    }

    private void fillCounter(Map<Long, Map<String, String>> mapCtTotal, Map<Long, Map<String, String>> mapCtToday, Map<Long, Response<Map<String, String>>> mapCtTotalRs, Map<Long, Response<Map<String, String>>> mapCtTodayRs) {
        Map map;
        Response<Map<String, String>> mapRs;
        Set<Long> keySet = mapCtTotalRs.keySet();
        for (Long id : keySet) {
            mapRs = mapCtTotalRs.get(id);
            map = (Map)mapRs.get();
            if (MapUtils.isEmpty((Map)map)) continue;
            mapCtTotal.put(id, map);
        }
        keySet = mapCtTodayRs.keySet();
        for (Long id : keySet) {
            mapRs = mapCtTodayRs.get(id);
            map = (Map)mapRs.get();
            if (MapUtils.isEmpty((Map)map)) continue;
            mapCtToday.put(id, map);
        }
    }
}

