/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter.task;

import com.alibaba.fastjson.JSON;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.facade.rule.task.TaskFrequencyRuleSo;
import com.bxm.adx.service.common.sifter.task.TaskAbstractSifter;
import com.bxm.adx.service.common.sifter.task.TaskChainData;
import com.bxm.adx.service.common.sifter.task.TaskData;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.sifter.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class TaskFrequencySifter
extends TaskAbstractSifter {
    private static final Logger log = LoggerFactory.getLogger(TaskFrequencySifter.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public boolean filter(Context<TaskData> context) {
        this.fillFrequency(context);
        return this.filterFrequency(context);
    }

    private boolean filterFrequency(Context<TaskData> context) {
        TaskCache data = ((TaskData)context.getData()).getTaskCache();
        Map<String, String> map = ((TaskData)context.getData()).getMapCtTodayDev().get(data.getId());
        TaskFrequencyRuleSo rule = ((TaskData)context.getData()).getMapFreqRule().get(data.getId());
        if (MapUtils.isEmpty(map) || null == rule) {
            return false;
        }
        Long views = NumberUtils.toLong((String)map.get("VIEWS"), (long)0L);
        Long clicks = NumberUtils.toLong((String)map.get("CLICKS"), (long)0L);
        Long wakes = NumberUtils.toLong((String)map.get("WAKES"), (long)0L);
        List<TaskFrequencyRuleSo.Entry> entries = rule.getEntries();
        for (TaskFrequencyRuleSo.Entry entry : entries) {
            if (1 != entry.getCycle()) continue;
            if (1 == entry.getType()) {
                if (views < entry.getCount()) continue;
                super.addReason(context, "\u5355\u8bbe\u5907\u65e5\u66dd\u5149\u9650\u5236");
                return true;
            }
            if (2 == entry.getType()) {
                if (clicks < entry.getCount()) continue;
                super.addReason(context, "\u5355\u8bbe\u5907\u65e5\u70b9\u51fb\u9650\u5236");
                return true;
            }
            if (3 != entry.getType() || wakes < entry.getCount()) continue;
            super.addReason(context, "\u5355\u8bbe\u5907\u65e5\u5524\u9192\u9650\u5236");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillFrequency(Context<TaskData> context) {
        TaskData data = (TaskData)context.getData();
        if (Boolean.TRUE.equals(data.getFlagFrequency())) {
            return;
        }
        List<Long> ids = super.getIds(context);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        TaskChainData chainData = ((TaskData)context.getData()).getChainData();
        HashMap<Long, Map<String, String>> mapCtTodayDev = new HashMap<Long, Map<String, String>>();
        HashMap<Long, TaskFrequencyRuleSo> mapFreqRule = new HashMap<Long, TaskFrequencyRuleSo>();
        data.setFlagFrequency(Boolean.TRUE);
        data.setMapCtTodayDev(mapCtTodayDev);
        data.setMapFreqRule(mapFreqRule);
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = null;
        HashMap<Long, Response<Map<String, String>>> mapCtTodayDevRs = new HashMap<Long, Response<Map<String, String>>>();
        HashMap<Long, Response<String>> mapFreqRuleRs = new HashMap<Long, Response<String>>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (Long id : ids) {
                mapCtTodayDevRs.put(id, (Response<Map<String, String>>)pipeline.hgetAll(AdxKeyGenerator.Task.getCounter(id, chainData.getTodayYmd(), data.getRequest().getDevUid()).generateKey()));
                mapFreqRuleRs.put(id, (Response<String>)pipeline.get(AdxKeyGenerator.Task.getFrequencyRule(id).generateKey()));
            }
            pipeline.syncAndReturnAll();
        }
        catch (Exception e) {
            log.error("fillFrequency error: ids={},e={}", ids, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        this.fillFrequency(mapCtTodayDev, mapFreqRule, mapCtTodayDevRs, mapFreqRuleRs);
    }

    private void fillFrequency(Map<Long, Map<String, String>> mapCtTodayDev, Map<Long, TaskFrequencyRuleSo> mapFreqRule, Map<Long, Response<Map<String, String>>> mapCtTodayDevRs, Map<Long, Response<String>> mapFreqRuleRs) {
        Set<Long> keySet = mapCtTodayDevRs.keySet();
        for (Long id : keySet) {
            Response<Map<String, String>> mapRs = mapCtTodayDevRs.get(id);
            Map map = (Map)mapRs.get();
            if (MapUtils.isEmpty((Map)map)) continue;
            mapCtTodayDev.put(id, map);
        }
        keySet = mapFreqRuleRs.keySet();
        for (Long id : keySet) {
            Response<String> strRs = mapFreqRuleRs.get(id);
            String str = (String)strRs.get();
            if (StringUtils.isBlank((String)str)) continue;
            mapFreqRule.put(id, (TaskFrequencyRuleSo)JSON.parseObject((String)str, TaskFrequencyRuleSo.class));
        }
    }
}

