/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter.task;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.service.common.sifter.task.TaskAbstractSifter;
import com.bxm.adx.service.common.sifter.task.TaskData;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.sifter.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class TaskTimeIntervalSifter
extends TaskAbstractSifter {
    private static final Logger log = LoggerFactory.getLogger(TaskTimeIntervalSifter.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public boolean filter(Context<TaskData> context) {
        this.fillTimeInterval(context);
        return this.filterTimeInterval(context);
    }

    private boolean filterTimeInterval(Context<TaskData> context) {
        TaskCache data = ((TaskData)context.getData()).getTaskCache();
        Long acqTime = ((TaskData)context.getData()).getMapTimeInterval().get(data.getId());
        if (null == acqTime || null == data.getTimeInterval()) {
            return false;
        }
        Long currentTime = ((TaskData)context.getData()).getChainData().getToday().getTime();
        if (currentTime - acqTime < (long)(data.getTimeInterval() * 60 * 1000)) {
            super.addReason(context, "\u540c\u4e00\u4efb\u52a1\u4e0b\u53d1\u95f4\u9694\u65f6\u95f4\u9650\u5236");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTimeInterval(Context<TaskData> context) {
        TaskData data = (TaskData)context.getData();
        if (Boolean.TRUE.equals(data.getFlagTimeInterval())) {
            return;
        }
        List<Long> ids = super.getIds(context);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        HashMap<Long, Long> mapTimeInterval = new HashMap<Long, Long>();
        data.setFlagTimeInterval(Boolean.TRUE);
        data.setMapTimeInterval(mapTimeInterval);
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = null;
        HashMap<Long, Response<String>> mapTimeIntervalRs = new HashMap<Long, Response<String>>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (Long id : ids) {
                mapTimeIntervalRs.put(id, (Response<String>)pipeline.get(AdxKeyGenerator.Counter.getTaskAcquireTime(id, data.getRequest().getDevUid()).generateKey()));
            }
            pipeline.syncAndReturnAll();
        }
        catch (Exception e) {
            log.error("fillTimeInterval error: ids={},e={}", ids, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        this.fillTimeInterval(mapTimeInterval, mapTimeIntervalRs);
    }

    private void fillTimeInterval(Map<Long, Long> mapTimeInterval, Map<Long, Response<String>> mapTimeIntervalRs) {
        Set<Long> keySet = mapTimeIntervalRs.keySet();
        for (Long id : keySet) {
            Response<String> strRs = mapTimeIntervalRs.get(id);
            String str = (String)strRs.get();
            if (StringUtils.isEmpty((String)str)) continue;
            mapTimeInterval.put(id, Long.valueOf(str));
        }
    }
}

