/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.controller;

import com.bxm.adx.service.entity.ActivityPosInfo;
import com.bxm.adx.service.entity.ActivityPosInfoQueryDTO;
import com.bxm.adx.service.entity.ResponseTemplate;
import com.bxm.adx.service.service.ActivitySceneService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ActivityController {
    private static final Logger log = LoggerFactory.getLogger(ActivityController.class);
    private final ActivitySceneService activitySceneService;

    public ActivityController(ActivitySceneService activitySceneService) {
        this.activitySceneService = activitySceneService;
    }

    @GetMapping(value={"/activity/positionInfo"})
    public ResponseEntity<? extends ResponseTemplate> getActivityPosInfo(@Validated ActivityPosInfoQueryDTO queryDTO) {
        ActivityPosInfo activityPosInfo = this.activitySceneService.getActivityPosInfo(queryDTO.getPositionId(), queryDTO.getActivityId());
        ResponseTemplate<ActivityPosInfo> template = ResponseTemplate.builder().code(activityPosInfo == null ? "404001" : "0").msg(activityPosInfo == null ? "result empty" : "").data(activityPosInfo).build();
        return ResponseEntity.ok(template);
    }
}

