/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.controller;

import com.bxm.adx.facade.model.task.TaskInfo;
import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.service.TaskService;
import com.bxm.adx.service.common.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.web.util.Encrypted;
import com.bxm.warcar.web.util.EncryptedMessage;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskController {
    private final TaskService taskService;
    private final ApplicationGlobalConfig config;

    public TaskController(TaskService taskService, ApplicationGlobalConfig config) {
        this.taskService = taskService;
        this.config = config;
    }

    @PostMapping(value={"/sdk/tasks"})
    @Encrypted(model=TaskInfoRequest.class, encryptResponseEntity=true)
    public ResponseEntity<List<TaskInfo>> tasksDES(@RequestBody EncryptedMessage<TaskInfoRequest> message, HttpServletRequest request) {
        if (!this.config.isEnableTask()) {
            return ResponseEntity.ok().build();
        }
        TaskInfoRequest taskRequest = (TaskInfoRequest)message.getObject();
        taskRequest.setIp(IpHelper.getIpFromHeader((HttpServletRequest)request));
        taskRequest.setUa(request.getHeader("User-Agent"));
        return ResponseEntity.ok(this.taskService.getTasks(taskRequest));
    }
}

