/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.service.impl;

import com.bxm.adx.service.common.autoconfigure.CityConfiguration;
import com.bxm.adx.service.common.autoconfigure.XinDongConfiguration;
import com.bxm.adx.service.common.autoconfigure.config.CityConfig;
import com.bxm.adx.service.entity.WeatherInfo;
import com.bxm.adx.service.entity.WeatherQueryDTO;
import com.bxm.adx.service.service.IpService;
import com.bxm.adx.service.service.SupportService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public class SupportServiceImpl
implements SupportService {
    private static final Logger log = LoggerFactory.getLogger(SupportServiceImpl.class);
    private static final String BASE = "\u5317\u4eac\u5e02";
    @Resource
    private CityConfiguration cityConfiguration;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Resource
    private IpService ipService;
    @Resource
    private XinDongConfiguration xinDongConfiguration;
    @Resource
    private Updater updater;
    @Resource
    private RestTemplate wakeRestTemplate;
    @Resource
    private JedisPool jedisPool;

    @Override
    public WeatherInfo getWeather(WeatherQueryDTO weatherQueryDTO) {
        IP ip;
        String province = weatherQueryDTO.getProvince();
        String city = weatherQueryDTO.getCity();
        if (StringUtils.isEmpty((Object)province) && StringUtils.isEmpty((Object)city) && !StringUtils.isEmpty((Object)weatherQueryDTO.getIp()) && (ip = this.ipService.analyze(weatherQueryDTO.getIp())) != null) {
            province = ip.getProvince();
            if (!(StringUtils.isEmpty((Object)province) || "\u5c40\u57df\u7f51".equals(province) || "\u4e2d\u56fd".equals(province))) {
                province = province + "\u7701";
            }
            if (!StringUtils.isEmpty((Object)(city = ip.getCity())) && !"\u4e2d\u56fd".equals(city)) {
                city = city + "\u5e02";
            }
        }
        String name = this.getName(province, city);
        List<CityConfig> cityConfigs = this.cityConfiguration.getCityConfigs();
        if (!CollectionUtils.isEmpty(cityConfigs)) {
            CityConfig c = cityConfigs.stream().filter(cityConfig -> cityConfig.getName().equals(name)).findFirst().orElse(null);
            if (c == null && !name.equals(BASE)) {
                c = cityConfigs.stream().filter(cityConfig -> cityConfig.getName().equals(BASE)).findFirst().orElse(null);
            }
            String id = c.getId();
            WeatherInfo weatherInfo = (WeatherInfo)this.fetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"ADX", "SDK", "SUPPORT", "WEATHER"}), id, WeatherInfo.class);
            return weatherInfo;
        }
        log.error("city BJ code err");
        return null;
    }

    private KeyGenerator cityConfigsKey() {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "SDK", "SUPPORT", "XD", "CITY"});
    }

    @Override
    public void xinDong() {
        this.init();
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.xinDongConfiguration.getBaseUrl());
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"key", (Object)this.xinDongConfiguration.getKey());
        params.add((Object)"language", (Object)"zh-Hans");
        params.add((Object)"unit", (Object)"c");
        try (Jedis jedis = this.jedisPool.getResource();){
            JsonNode result;
            JsonNode results;
            String city = jedis.lpop(this.cityConfigsKey().generateKey());
            if (StringUtils.isEmpty((Object)city)) {
                return;
            }
            CityConfig cc = (CityConfig)JsonHelper.convert((String)city, CityConfig.class);
            params.add((Object)"location", (Object)cc.getId());
            URI uri = builder.queryParams((MultiValueMap)params).build().encode().toUri();
            JsonNode resultJson = null;
            try {
                resultJson = (JsonNode)this.wakeRestTemplate.getForObject(uri, JsonNode.class);
            }
            catch (HttpClientErrorException e) {
                if (log.isWarnEnabled()) {
                    log.warn("xindong warning = {}", (Object)e.getResponseBodyAsString());
                }
                if (jedis != null) {
                    if (var4_4 != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        jedis.close();
                    }
                }
                return;
            }
            if (resultJson.has("results") && (results = resultJson.get("results")).isArray() && results.has(0) && (result = results.get(0)).has("now")) {
                JsonNode now = result.get("now");
                String temp = now.get("temperature").asText();
                String text = now.get("text").asText();
                if (!StringUtils.isEmpty((Object)temp) && !StringUtils.isEmpty((Object)text)) {
                    WeatherInfo weatherInfo = new WeatherInfo();
                    weatherInfo.setTemperature(temp);
                    weatherInfo.setText(text);
                    this.updater.hupdate(() -> KeyBuilder.build((Object[])new Object[]{"ADX", "SDK", "SUPPORT", "WEATHER"}), cc.getId(), (Object)weatherInfo);
                }
            }
        }
    }

    private void init() {
        try (Jedis jedis = this.jedisPool.getResource();){
            if (!jedis.exists(this.cityConfigsKey().generateKey()).booleanValue() || jedis.llen(this.cityConfigsKey().generateKey()) <= 0L) {
                List<CityConfig> cityConfigs = this.cityConfiguration.getCityConfigs();
                for (CityConfig cityConfig : cityConfigs) {
                    String city;
                    String province;
                    String[] names;
                    String name = cityConfig.getName();
                    if (StringUtils.isEmpty((Object)name) || (names = name.split("/")).length <= 0 || !StringUtils.isEmpty((Object)(province = names[0])) && (province.contains("\u5e02") && names.length > 1 || province.contains("\u7701") && names.length > 1 && !StringUtils.isEmpty((Object)(city = names[1])) && city.contains("\u5e02") && names.length > 2)) continue;
                    jedis.lpush(this.cityConfigsKey().generateKey(), new String[]{JsonHelper.convert((Object)cityConfig)});
                }
            }
        }
    }

    private String getName(String province, String city) {
        if (StringUtils.isEmpty((Object)province)) {
            if (StringUtils.isEmpty((Object)city)) {
                return BASE;
            }
            return city;
        }
        if (StringUtils.isEmpty((Object)city)) {
            return province;
        }
        if (province.equals(city)) {
            return city;
        }
        return province + "/" + city;
    }
}

