/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.autoconfigure.dc.dot;

import com.bxm.warcar.integration.autoconfigure.dc.dot.DotProperties;
import com.bxm.warcar.integration.dc.dot.AsyncDot;
import com.bxm.warcar.integration.dc.dot.Dot;
import com.bxm.warcar.integration.dc.dot.impl.DefaultDotImpl;
import com.bxm.warcar.integration.dc.dot.impl.ThreadPoolExecutorDotImpl;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={DotProperties.class})
public class DotAutoConfiguration {
    private final DotProperties properties;

    public DotAutoConfiguration(DotProperties properties) {
        this.properties = properties;
    }

    @Bean
    public Dot dot() {
        return new DefaultDotImpl(this.properties.getUrl());
    }

    @Primary
    @Bean
    public AsyncDot asyncDot() {
        DotProperties.ThreadPoolProperties threadPool = this.properties.getThreadPool();
        return new ThreadPoolExecutorDotImpl(this.dot(), threadPool.getPoolCoreSize(), threadPool.getAwaitTerminationTimeInSeconds());
    }
}

