#!/bin/bash

if [ ! -f ~/run/adx-service.pid ]; then
  echo "Server [adx-service] doest not started!"
  exit
fi

pid=`cat ~/run/adx-service.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in adx-service.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [adx-service] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [adx-service] cannot stop, Please check pid file 'adx-service.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [adx-service] has been stoped!"
fi

rm -f ~/run/adx-service.pid