/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.timer.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adx.timer.common.MediaEntranceCreativesBuider;
import com.bxm.adx.timer.common.OpenClickModel;
import com.bxm.adx.timer.service.MediaEntranceCreativesService;
import com.bxm.warcar.algorithm.NumericalModel;
import com.bxm.warcar.algorithm.RequestModel;
import com.bxm.warcar.algorithm.flow.service.FlowAlgorithmService;
import com.bxm.warcar.algorithm.utils.DoubleUtils;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class MediaEntranceCreativesServiceImpl
implements MediaEntranceCreativesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaEntranceCreativesService.class);
    private LoadingCache<String, Map<String, String>> positionPvCache = CacheBuilder.newBuilder().refreshAfterWrite(1L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Map<String, String>>(){

        public Map<String, String> load(String key) {
            return MediaEntranceCreativesServiceImpl.this.fetcher.hfetchall(MediaEntranceCreativesBuider.positionPrePv(LocalDateTimeHelper.preDateString()), String.class);
        }
    });
    private static final ExecutorService pool = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 0L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("positionMaterial"));
    @Autowired
    private FlowAlgorithmService flowAlgorithmService;
    @Qualifier(value="jedisFetcher")
    @Autowired
    private Fetcher fetcher;
    @Qualifier(value="jedisUpdater")
    @Autowired
    private Updater updater;

    @Override
    public void flowAlgorithm() throws Exception {
        long startTime = System.currentTimeMillis();
        Map positionPvMap = this.positionPvCache.size() > 0L ? (Map)this.positionPvCache.get((Object)"") : this.fetcher.hfetchall(MediaEntranceCreativesBuider.positionPrePv(LocalDateTimeHelper.preDateString()), String.class);
        if (MapUtils.isEmpty((Map)positionPvMap)) {
            LOGGER.warn("\u67e5\u8be2\u6240\u6709\u5e7f\u544a\u4f4d\u6628\u65e5\u66dd\u5149PV\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        Map rateMap = this.fetcher.hfetchall(MediaEntranceCreativesBuider.positionClickRate24H(), String.class);
        if (MapUtils.isEmpty((Map)rateMap)) {
            LOGGER.warn("\u67e5\u8be2\u6240\u6709\u5e7f\u544a\u4f4d\u6700\u8fd124\u5c0f\u65f6\u70b9\u51fb\u7387\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        Set entries = rateMap.entrySet();
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>(rateMap.size());
        AtomicInteger atomicInteger = new AtomicInteger(1);
        for (Map.Entry entry : entries) {
            Future<Integer> future2 = pool.submit(() -> {
                this.doFlow(positionPvMap, entry);
                return atomicInteger.getAndIncrement();
            });
            futures.add(future2);
        }
        futures.forEach(future -> {
            try {
                int index = (Integer)future.get();
                if (index == 1 || index % 100 == 0 || index == futures.size()) {
                    LOGGER.info("Update material flow  {} / {} .", (Object)index, (Object)futures.size());
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        });
        LOGGER.info("Update material flow finished {} s ", (Object)DoubleUtils.divide((double[])new double[]{System.currentTimeMillis() - startTime, 1000.0}));
    }

    private void doFlow(Map<String, String> positionPvMap, Map.Entry<String, String> entry) {
        String positionId = entry.getKey();
        String positionValue = entry.getValue();
        if (StringUtils.isBlank((String)positionValue)) {
            return;
        }
        OpenClickModel positionModel = (OpenClickModel)JSON.parseObject((String)positionValue, OpenClickModel.class);
        List<String> materialIds = this.fetchMaterialIds(positionId);
        if (CollectionUtils.isEmpty(materialIds)) {
            LOGGER.warn("position : {} material is empty . ", (Object)positionId);
            return;
        }
        ArrayList<NumericalModel> numericalModels = new ArrayList<NumericalModel>(materialIds.size());
        String preGroupDatePvString = positionPvMap.get(positionId);
        long preGroupDatePv = 0L;
        if (StringUtils.isNotBlank((String)preGroupDatePvString)) {
            preGroupDatePv = Long.parseLong(preGroupDatePvString);
        }
        for (String id : materialIds) {
            numericalModels.add(this.convertNumericalModel(id, positionId, positionModel, preGroupDatePv));
        }
        RequestModel requestModel = new RequestModel(numericalModels);
        requestModel = this.flowAlgorithmService.deServie(requestModel);
        this.writeRedis((RequestModel<NumericalModel>)requestModel, positionId);
    }

    private NumericalModel convertNumericalModel(String id, String positionId, OpenClickModel positionModel, long preGroupDatePv) {
        NumericalModel model = new NumericalModel(id, positionId, Long.valueOf(0L), Long.valueOf(preGroupDatePv), Double.valueOf(positionModel.getClickRate()), Double.valueOf(0.0));
        try {
            String materialclickRate;
            String clickRate24h;
            String clickRate2h = (String)this.fetcher.hfetch(MediaEntranceCreativesBuider.clickRate2H(positionId), id, String.class);
            if (StringUtils.isNotBlank((String)clickRate2h)) {
                OpenClickModel clickRate2hModel = (OpenClickModel)JSON.parseObject((String)clickRate2h, OpenClickModel.class);
                model.setClickRate2H(clickRate2hModel.getClickRate());
                model.setOpenPv2H(Long.valueOf(clickRate2hModel.getExposurePv()));
            }
            if (StringUtils.isNotBlank((String)(clickRate24h = (String)this.fetcher.hfetch(MediaEntranceCreativesBuider.clickRate24H(positionId), id, String.class)))) {
                OpenClickModel clickRate24hModel = (OpenClickModel)JSON.parseObject((String)clickRate24h, OpenClickModel.class);
                model.setClickRate24H(clickRate24hModel.getClickRate());
                model.setOpenPv24H(Long.valueOf(clickRate24hModel.getExposurePv()));
            }
            if (StringUtils.isNotBlank((String)(materialclickRate = (String)this.fetcher.hfetch(MediaEntranceCreativesBuider.clickRate(positionId), id, String.class)))) {
                OpenClickModel materialclickRateModel = (OpenClickModel)JSON.parseObject((String)materialclickRate, OpenClickModel.class);
                model.setClickRate(materialclickRateModel.getClickRate());
                model.setOpenPv(Long.valueOf(materialclickRateModel.getExposurePv()));
            }
            return model;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return model;
        }
    }

    private List<String> fetchMaterialIds(String positionId) {
        String ids = (String)this.fetcher.hfetch(MediaEntranceCreativesBuider.positionAllCreatives(), positionId, String.class);
        if (StringUtils.isNotBlank((String)ids)) {
            return JSONObject.parseArray((String)ids, String.class);
        }
        return null;
    }

    private void writeRedis(RequestModel<NumericalModel> requestModel, String positionId) {
        if (requestModel == null) {
            return;
        }
        Map map = requestModel.getMap();
        if (MapUtils.isEmpty((Map)map)) {
            return;
        }
        this.updater.update(MediaEntranceCreativesBuider.flowRate(positionId), (Object)JSONObject.toJSONString((Object)map));
    }
}

