/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.deeplink.common;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.buyer.AbstractBuyer;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.Asset;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.Image;
import com.bxm.adx.common.sell.response.Native;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.model.dev.DevRequest;
import com.bxm.adx.facade.service.UserService;
import com.bxm.adx.plugins.deeplink.common.AbstractDeepLinkBuyModelAdapter;
import com.bxm.adx.plugins.deeplink.common.AbstractDeepLinkPluginConfig;
import com.bxm.adx.plugins.deeplink.common.RequestFilter;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDeepLinkBuyer
extends AbstractBuyer {
    private final AbstractDeepLinkPluginConfig config;
    private final AbstractDeepLinkBuyModelAdapter buyModelAdapter;
    private final UserService userService;
    private final RequestFilter requestFilter;

    public AbstractDeepLinkBuyer(AbstractDeepLinkPluginConfig config, AbstractDeepLinkBuyModelAdapter buyModelAdapter, UserService userService, RequestFilter requestFilter) {
        this.config = config;
        this.buyModelAdapter = buyModelAdapter;
        this.userService = userService;
        this.requestFilter = requestFilter;
    }

    protected byte[] request(byte[] requestBody) {
        BidRequest request = (BidRequest)JsonHelper.convert((byte[])requestBody, BidRequest.class);
        Device device = request.getDevice();
        DevRequest.DevRequestBuilder builder = DevRequest.builder();
        builder.os(Integer.valueOf(this.getOs(device.getOs()))).imei(device.getImei()).imeiMd5(device.getImei_md5()).anid(device.getDpid()).anidMd5(device.getDpid_md5()).idfa(device.getIdfa()).idfaMd5(device.getIdfa_md5());
        List appList = this.userService.getInstalledList(builder.build());
        Dsp dsp = this.getDsp();
        if (this.requestFilter.abort(request, appList, dsp)) {
            return null;
        }
        BidResponse response = new BidResponse();
        ArrayList seatBids = Lists.newArrayList();
        response.setSeat_bid((List)seatBids);
        List imps = request.getImps();
        for (Impression imp : imps) {
            SeatBid seatBid = new SeatBid().setDspId(this.getDsp().getId());
            seatBids.add(seatBid);
            ArrayList<Bid> bids = new ArrayList<Bid>();
            Bid bid = new Bid().setPrice(Float.valueOf(0.0f)).setC_type(Integer.valueOf(9)).setType(Integer.valueOf(2)).setTag_id(imp.getTag_id()).setImp_id(imp.getId()).setDeep_link_url(this.config.getDeeplink());
            Native nt = new Native();
            ArrayList<Asset> assets = new ArrayList<Asset>();
            AbstractDeepLinkPluginConfig.ImageConfig image = this.config.randomImage();
            Asset asset = new Asset().setId(image.getId()).setType(Integer.valueOf(7)).setImg(new Image().setUrl(image.getUrl()));
            assets.add(asset);
            nt.setAssets(assets);
            bid.setCreate_id(image.getId());
            bid.setA_native(nt);
            bids.add(bid);
            seatBid.setBid(bids);
        }
        this.requestFilter.afterCompletion(request);
        return JsonHelper.convert2bytes((Object)response);
    }

    public String getCode() {
        return this.config.getKey();
    }

    public BuyModelAdapter getModelAdapter() {
        return this.buyModelAdapter;
    }

    private int getOs(String os) {
        if (StringUtils.isBlank((String)os)) {
            return 0;
        }
        return StringUtils.equalsIgnoreCase((String)os, (String)"ios") ? 2 : (StringUtils.equalsIgnoreCase((String)os, (String)"android") ? 1 : 0);
    }
}

