package com.bxm.adx.plugins.bxm;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.warcar.utils.JsonHelper;
import org.springframework.stereotype.Service;

/**
 * @author allen
 * @since 2019-12-13
 */
@Service
public class BxmBuyModelAdapter implements BuyModelAdapter {
    @Override
    public byte[] buildRequest(BidRequest request) {
        return JsonHelper.convert2bytes(request);
    }

    @Override
    public BidResponse buildResponse(byte[] response) {
        return JsonHelper.convert(response, BidResponse.class);
    }
}
