package com.bxm.adx.plugins.bxm;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.buyer.AbstractHttpBuyer;
import com.bxm.warcar.dpl2.plugin.PluginConfig;
import com.bxm.warcar.dpl2.plugin.PluginConfigAware;
import org.springframework.stereotype.Service;

/**
 * @author allen
 * @since 2019-12-13
 */
@Service
public class BxmBuyer extends AbstractHttpBuyer implements PluginConfigAware {

    private final BxmBuyModelAdapter adapter;

    private PluginConfig pluginConfig;

    public BxmBuyer(AdxProperties properties, BxmBuyModelAdapter adapter) {
        super(properties);
        this.adapter = adapter;
    }

    @Override
    public BuyModelAdapter getModelAdapter() {
        return adapter;
    }

    @Override
    public String getCode() {
        return pluginConfig.getKey();
    }

    @Override
    public void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }
}
