package com.bxm.adx.plugins.inmobi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adx.common.AdxException;
import com.bxm.adx.common.adapter.AbstractFastjsonBuyModelAdapter;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherDao;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.*;
import com.bxm.adx.plugins.inmobi.entity.InMobiRequest;
import com.bxm.adx.plugins.inmobi.entity.InMobiResponse;
import com.bxm.adx.plugins.inmobi.entity.req.*;
import com.bxm.adx.plugins.inmobi.entity.req.Native;
import com.bxm.adx.plugins.inmobi.entity.resp.Ad;
import com.bxm.adx.plugins.inmobi.entity.resp.EventTacking;
import com.bxm.adx.plugins.inmobi.entity.resp.MaterialMeta;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * {
 * "ads": [{
 * "adid": "519076",
 * "pubContent": {
 * "landingURL": "",
 * "title": "滴滴出行",
 * "description": "来试试？赢最低5折出行券",
 * "cta": "了解更多",
 * "icon": {
 * "url": "https://orangefire.didistatic.com/static/orangefire/8nkc0008s1eumssjf4sss862.jpg",
 * "width": 100.0,
 * "height": 100.0,
 * "aspectRatio": 1.0
 * },
 * "screenshots": {
 * "url": "https://orangefire.didistatic.com/static/orangefire/8nkc0008s1eumssjf4sss86e.jpg",
 * "width": 320.0,
 * "height": 568.0,
 * "aspectRatio": 0.56
 * }* 		},
 * "expirationTime": 9000,
 * "targetUrl": "https://v.didi.cn/p/gqD1Rd?dsp_uuid=uI8nO424Med1OqtEL-KJ",
 * "eventTracking": {
 * "impressionTrackers": ["https://tracker.inmobi.cn/beacon/CiQxZDkzMjQzNDZmMTE1OTk3MzZlNDUzZjAxMDcwMzY4MDM2MjYaEDIwMDAwMDAwMDAwMDAyNTMgEiqxASIGNTE5MDc2KiAxOWEzMmEyNDI0MTk3MGM3NGE4OTc4ZTQwMTEyNjIwODDLMzjpGkABUPyaFlgBYiBmNDhmNzI2OTg5ZDUxNjA0NmVmOTIwMzA1OTE4NDNhMHIgN2I4OThiODJjMjEzNDFhYWI1YWVlNDdmOGQ3YTFkNDJ6IDE3NDMwMmYwNzQ0MTU3YTcyOGE0M2EzOTgxOTE5NjgwnQHD9cg-wQG4HoXrUbiuP8gBATABOAFCIDE5YTMyYTI0MjQxOTcwYzc0YTg5NzhlNDAxMTI2MjA4Sg0xMTUuMjA2LjEzLjY0WsABTW96aWxsYS81LjAgKExpbnV4OyBVOyBBbmRyb2lkIDguMS4wOyB6aC1jbjsgTUkgNVggQnVpbGQvT1BNMS4xNzEwMTkuMDE5KSBBcHBsZVdlYktpdC81MzcuMzYgKEtIVE1MLCBsaWtlIEdlY2tvKSBWZXJzaW9uLzQuMCBDaHJvbWUvNjEuMC4zMTYzLjEyOCBNb2JpbGUgU2FmYXJpLzUzNy4zNiBYaWFvTWkvTWl1aUJyb3dzZXIvMTAuOC4zag9zeS1xYS5pbm1vYmkuY25yDTE2MDQ2NDc5NzU5NjiIAQOQAQKaAV5iEDVhMmMwMDliMjA3ZGVlZjVqIDI2MDQ1NzJlZjZkMWEzZTk1NDJhNDg0YjFkMzBhOWNmcihiZjMzZjA4NTdjMGE4MmQ4ZmM0NjYxZGZmNzc5OThiOTZlZDliMGYw4gEiCiAxM2QzMDlhOTBkNDczOWQ1MDFiNDFmZDU2ZDUxNjM1Mg/BHVSyubt6X_S-DCbmLVHwgYrnQ0?m=18&ts=$TS", "https://dsp.xiaojukeji.com/trk/imp?rp=uspK2-6xPrAzO0QZNG6IpEcaC16poEkyrxRHXlz5ow0SOwWspQMtPQWG4QunsEwI_ac4hMnSexM3SwtrPE4Zp0225HSY4YB9pYEiOHQYpNSYO1SYO0trPE4A4fWsBsC9sQstsQWtsnQtuD3-WlD4WdG9TFht0YQZp0sXpHeqpYQMRYEiPyWttJQtuTOLSRxnVfCqCR0Qs40Ks49aOYEAONsMpHBXpHWjOOhtszQt0H1XOK9YOX9aOHQlpNBMdW1-pH4Mp0QXPShuss.Ia1514&wp=36.39"],
 * "clickTrackers": ["https://tracker.inmobi.cn/click/CiQxZDkzMjQzNDZmMTE1OTk3MzZlNDUzZjAxMDcwMzY4MDM2MjYaEDIwMDAwMDAwMDAwMDAyNTMgCCqxASIGNTE5MDc2KiAxOWEzMmEyNDI0MTk3MGM3NGE4OTc4ZTQwMTEyNjIwODDLMzjpGkABUPyaFlgBYiBmNDhmNzI2OTg5ZDUxNjA0NmVmOTIwMzA1OTE4NDNhMHIgN2I4OThiODJjMjEzNDFhYWI1YWVlNDdmOGQ3YTFkNDJ6IDE3NDMwMmYwNzQ0MTU3YTcyOGE0M2EzOTgxOTE5NjgwnQHD9cg-wQG4HoXrUbiuP8gBATABOAFCIDE5YTMyYTI0MjQxOTcwYzc0YTg5NzhlNDAxMTI2MjA4Sg0xMTUuMjA2LjEzLjY0WsABTW96aWxsYS81LjAgKExpbnV4OyBVOyBBbmRyb2lkIDguMS4wOyB6aC1jbjsgTUkgNVggQnVpbGQvT1BNMS4xNzEwMTkuMDE5KSBBcHBsZVdlYktpdC81MzcuMzYgKEtIVE1MLCBsaWtlIEdlY2tvKSBWZXJzaW9uLzQuMCBDaHJvbWUvNjEuMC4zMTYzLjEyOCBNb2JpbGUgU2FmYXJpLzUzNy4zNiBYaWFvTWkvTWl1aUJyb3dzZXIvMTAuOC4zag9zeS1xYS5pbm1vYmkuY25yDTE2MDQ2NDc5NzU5NjiIAQOQAQKaAV5iEDVhMmMwMDliMjA3ZGVlZjVqIDI2MDQ1NzJlZjZkMWEzZTk1NDJhNDg0YjFkMzBhOWNmcihiZjMzZjA4NTdjMGE4MmQ4ZmM0NjYxZGZmNzc5OThiOTZlZDliMGYw4gEiCiAxM2QzMDlhOTBkNDczOWQ1MDFiNDFmZDU2ZDUxNjM1Mg/SeFSzZhPI0gLBlDJqGELpCMWIao?m=8&ts=$TS&dX=__DOWN_X__&dY=__DOWN_Y__&uX=__UP_X__&uY=__UP_Y__&ht=__HEIGHT__&wt=__WIDTH__&r_ht=__REQ_HEIGHT__&r_wt=__REQ_WIDTH__&c_area=__CLICKAREA__", "https://dsp.xiaojukeji.com/trk/clk?rp=uspK2-6xPrAzO0QZNG6IpEcaC16poEkyrxRHXlz5ow0SOwWspQMtPQWG4QunsEwI_ac4hMnSexM3SwtrPE4Zp0225HSY4YB9pYEiOHQYpNSYO1SYO0trPE4A4fWsBsC9sQstsQWtsnQtuD3-WlD4WdG9TFht0YQZp0sXpHeqpYQMRYEiPyWttJQtuTOLSRxnVfCqCR0Qs40Ks49aOYEAONsMpHBXpHWjOOhtszQt0H1XOK9YOX9aOHQlpNBMdW1-pH4Mp0QXPShuss.Ia1514"],
 * "downX": ["https://tracker.inmobi.cn/beacon/CiQxZDkzMjQzNDZmMTE1OTk3MzZlNDUzZjAxMDcwMzY4MDM2MjYaEDIwMDAwMDAwMDAwMDAyNTMghgEqsQEiBjUxOTA3NiogMTlhMzJhMjQyNDE5NzBjNzRhODk3OGU0MDExMjYyMDgwyzM46RpAAVD8mhZYAWIgZjQ4ZjcyNjk4OWQ1MTYwNDZlZjkyMDMwNTkxODQzYTByIDdiODk4YjgyYzIxMzQxYWFiNWFlZTQ3ZjhkN2ExZDQyeiAxNzQzMDJmMDc0NDE1N2E3MjhhNDNhMzk4MTkxOTY4MJ0Bw_XIPsEBuB6F61G4rj_IAQEwATgBQiAxOWEzMmEyNDI0MTk3MGM3NGE4OTc4ZTQwMTEyNjIwOEoNMTE1LjIwNi4xMy42NFrAAU1vemlsbGEvNS4wIChMaW51eDsgVTsgQW5kcm9pZCA4LjEuMDsgemgtY247IE1JIDVYIEJ1aWxkL09QTTEuMTcxMDE5LjAxOSkgQXBwbGVXZWJLaXQvNTM3LjM2IChLSFRNTCwgbGlrZSBHZWNrbykgVmVyc2lvbi80LjAgQ2hyb21lLzYxLjAuMzE2My4xMjggTW9iaWxlIFNhZmFyaS81MzcuMzYgWGlhb01pL01pdWlCcm93c2VyLzEwLjguM2oPc3ktcWEuaW5tb2JpLmNucg0xNjA0NjQ3OTc1OTY4iAEDkAECmgFeYhA1YTJjMDA5YjIwN2RlZWY1aiAyNjA0NTcyZWY2ZDFhM2U5NTQyYTQ4NGIxZDMwYTljZnIoYmYzM2YwODU3YzBhODJkOGZjNDY2MWRmZjc3OTk4Yjk2ZWQ5YjBmMOIBIgogMTNkMzA5YTkwZDQ3MzlkNTAxYjQxZmQ1NmQ1MTYzNTI/BIVGloQiHOTKKgScwritR9aySxA?m=134&ts=__DOWN_X__"],
 * "downY": ["https://tracker.inmobi.cn/beacon/CiQxZDkzMjQzNDZmMTE1OTk3MzZlNDUzZjAxMDcwMzY4MDM2MjYaEDIwMDAwMDAwMDAwMDAyNTMghwEqsQEiBjUxOTA3NiogMTlhMzJhMjQyNDE5NzBjNzRhODk3OGU0MDExMjYyMDgwyzM46RpAAVD8mhZYAWIgZjQ4ZjcyNjk4OWQ1MTYwNDZlZjkyMDMwNTkxODQzYTByIDdiODk4YjgyYzIxMzQxYWFiNWFlZTQ3ZjhkN2ExZDQyeiAxNzQzMDJmMDc0NDE1N2E3MjhhNDNhMzk4MTkxOTY4MJ0Bw_XIPsEBuB6F61G4rj_IAQEwATgBQiAxOWEzMmEyNDI0MTk3MGM3NGE4OTc4ZTQwMTEyNjIwOEoNMTE1LjIwNi4xMy42NFrAAU1vemlsbGEvNS4wIChMaW51eDsgVTsgQW5kcm9pZCA4LjEuMDsgemgtY247IE1JIDVYIEJ1aWxkL09QTTEuMTcxMDE5LjAxOSkgQXBwbGVXZWJLaXQvNTM3LjM2IChLSFRNTCwgbGlrZSBHZWNrbykgVmVyc2lvbi80LjAgQ2hyb21lLzYxLjAuMzE2My4xMjggTW9iaWxlIFNhZmFyaS81MzcuMzYgWGlhb01pL01pdWlCcm93c2VyLzEwLjguM2oPc3ktcWEuaW5tb2JpLmNucg0xNjA0NjQ3OTc1OTY4iAEDkAECmgFeYhA1YTJjMDA5YjIwN2RlZWY1aiAyNjA0NTcyZWY2ZDFhM2U5NTQyYTQ4NGIxZDMwYTljZnIoYmYzM2YwODU3YzBhODJkOGZjNDY2MWRmZjc3OTk4Yjk2ZWQ5YjBmMOIBIgogMTNkMzA5YTkwZDQ3MzlkNTAxYjQxZmQ1NmQ1MTYzNTI/OsGxoygfbh5aH6osxvUDr4B7l-4?m=135&ts=__DOWN_Y__"],
 * "upX": ["https://tracker.inmobi.cn/beacon/CiQxZDkzMjQzNDZmMTE1OTk3MzZlNDUzZjAxMDcwMzY4MDM2MjYaEDIwMDAwMDAwMDAwMDAyNTMgiAEqsQEiBjUxOTA3NiogMTlhMzJhMjQyNDE5NzBjNzRhODk3OGU0MDExMjYyMDgwyzM46RpAAVD8mhZYAWIgZjQ4ZjcyNjk4OWQ1MTYwNDZlZjkyMDMwNTkxODQzYTByIDdiODk4YjgyYzIxMzQxYWFiNWFlZTQ3ZjhkN2ExZDQyeiAxNzQzMDJmMDc0NDE1N2E3MjhhNDNhMzk4MTkxOTY4MJ0Bw_XIPsEBuB6F61G4rj_IAQEwATgBQiAxOWEzMmEyNDI0MTk3MGM3NGE4OTc4ZTQwMTEyNjIwOEoNMTE1LjIwNi4xMy42NFrAAU1vemlsbGEvNS4wIChMaW51eDsgVTsgQW5kcm9pZCA4LjEuMDsgemgtY247IE1JIDVYIEJ1aWxkL09QTTEuMTcxMDE5LjAxOSkgQXBwbGVXZWJLaXQvNTM3LjM2IChLSFRNTCwgbGlrZSBHZWNrbykgVmVyc2lvbi80LjAgQ2hyb21lLzYxLjAuMzE2My4xMjggTW9iaWxlIFNhZmFyaS81MzcuMzYgWGlhb01pL01pdWlCcm93c2VyLzEwLjguM2oPc3ktcWEuaW5tb2JpLmNucg0xNjA0NjQ3OTc1OTY4iAEDkAECmgFeYhA1YTJjMDA5YjIwN2RlZWY1aiAyNjA0NTcyZWY2ZDFhM2U5NTQyYTQ4NGIxZDMwYTljZnIoYmYzM2YwODU3YzBhODJkOGZjNDY2MWRmZjc3OTk4Yjk2ZWQ5YjBmMOIBIgogMTNkMzA5YTkwZDQ3MzlkNTAxYjQxZmQ1NmQ1MTYzNTI/vLuWO677wwOobS6LyJLlRJ6crgA?m=136&ts=__UP_X__"],
 * "upY": ["https://tracker.inmobi.cn/beacon/CiQxZDkzMjQzNDZmMTE1OTk3MzZlNDUzZjAxMDcwMzY4MDM2MjYaEDIwMDAwMDAwMDAwMDAyNTMgiQEqsQEiBjUxOTA3NiogMTlhMzJhMjQyNDE5NzBjNzRhODk3OGU0MDExMjYyMDgwyzM46RpAAVD8mhZYAWIgZjQ4ZjcyNjk4OWQ1MTYwNDZlZjkyMDMwNTkxODQzYTByIDdiODk4YjgyYzIxMzQxYWFiNWFlZTQ3ZjhkN2ExZDQyeiAxNzQzMDJmMDc0NDE1N2E3MjhhNDNhMzk4MTkxOTY4MJ0Bw_XIPsEBuB6F61G4rj_IAQEwATgBQiAxOWEzMmEyNDI0MTk3MGM3NGE4OTc4ZTQwMTEyNjIwOEoNMTE1LjIwNi4xMy42NFrAAU1vemlsbGEvNS4wIChMaW51eDsgVTsgQW5kcm9pZCA4LjEuMDsgemgtY247IE1JIDVYIEJ1aWxkL09QTTEuMTcxMDE5LjAxOSkgQXBwbGVXZWJLaXQvNTM3LjM2IChLSFRNTCwgbGlrZSBHZWNrbykgVmVyc2lvbi80LjAgQ2hyb21lLzYxLjAuMzE2My4xMjggTW9iaWxlIFNhZmFyaS81MzcuMzYgWGlhb01pL01pdWlCcm93c2VyLzEwLjguM2oPc3ktcWEuaW5tb2JpLmNucg0xNjA0NjQ3OTc1OTY4iAEDkAECmgFeYhA1YTJjMDA5YjIwN2RlZWY1aiAyNjA0NTcyZWY2ZDFhM2U5NTQyYTQ4NGIxZDMwYTljZnIoYmYzM2YwODU3YzBhODJkOGZjNDY2MWRmZjc3OTk4Yjk2ZWQ5YjBmMOIBIgogMTNkMzA5YTkwZDQ3MzlkNTAxYjQxZmQ1NmQ1MTYzNTI/xUi4Cbf05sEbixH6hflf3fm8ysc?m=137&ts=__UP_Y__"]
 * },
 * "isApp": false,
 * "openExternal": false
 * }],
 * "requestId": "1d9324346f11599736e453f0107036803626"
 * }
 */
@Service
@Slf4j
public class InMobiBuyModelAdapter extends AbstractFastjsonBuyModelAdapter {

    @Autowired
    private DispatcherDao dispatcherDao;
    @Autowired
    private InmobiPluginConfig config;

    @Override
    public byte[] buildRequest(BidRequest request) {
        InMobiRequest inMobiRequest = new InMobiRequest();
        List<Impression> impressions = request.getImps();

        if (CollectionUtils.isEmpty(impressions)) {
            throw new AdxException("imps is null");
        }
        Impression impression = impressions.get(0);
        if (impression == null) {
            throw new AdxException("imp is null");
        }

        final com.bxm.adx.common.sell.request.Device device1 = request.getDevice();
        if (device1 == null) {
            throw new AdxException("device is null");
        }

        Dispatcher dispatcher = dispatcherDao.get(impression.getTag_id(), config.getDspId().toString());

        App app = new App();
        inMobiRequest.setApp(app);
        app.setId(dispatcher.getDspPosid());
        app.setBundle(device1.getBrand());

        Imp imp = new Imp();
        inMobiRequest.setImp(imp);
        Native a = new Native();
        imp.setANative(a);
        a.setLayout(0);

        Banner banner = new Banner();

        imp.setBanner(banner);
        banner.setW(320);
        //interstitial 480 banner 50
        banner.setH(50);

        imp.setSecure(0);
        imp.setTrackertype("webview");
        Imp.Ext ext = new Imp.Ext();
        ext.setAdsCount(1);
        imp.setExt(ext);

        Device device = Device.builder()
                .connectiontype(device1.getConnection_type())
                //.gpid() 中国可以不传
                .ifa(device1.getIdfa())
                .ip(device1.getIp())
                .md5_imei(device1.getImei_md5())
                .model(device1.getModel())
                //Android ID 59765d901fcf6dd6
                .o1(DigestUtils.sha1Hex(device1.getDpid()))
                .um5(DigestUtils.md5Hex(device1.getDpid()))
                //oaid 当前版本还不支持
                .oaid("5a2c009b207deef5")
                .os(device1.getOs())
                .osv(device1.getOsv())
                .sha1_imei(DigestUtils.sha1Hex(device1.getImei()))
                .type("1")
                .ua(device1.getUa())
                .build();
        inMobiRequest.setDevice(device);

        InMobiRequest.Ext e = new InMobiRequest.Ext();
        e.setResponseformat("json");
        e.setSupportDeeplink(true);

        return JsonHelper.convert2bytes(inMobiRequest);
    }

    @Override
    public BidResponse buildResponse(byte[] response) {
        InMobiResponse inMobiResponse = convert(response);

        Ad ad = inMobiResponse.getAds().get(0);
        Bid bid = new Bid();
        bid.setPrice(0.0f);
        bid.setClick_through_url(ad.getTargetUrl());
        //这里是用WebView打开网页
        bid.setC_type(6);
        // 图文
        bid.setType(2);

        //检测地址下发
        List<ClickMonitor> clickMonitors = Lists.newArrayList();
        for (int i = 0; i < ad.getEventTacking().getClickTrackers().size(); i++) {
            ClickMonitor clickMonitor = new ClickMonitor();
            clickMonitor.setClick_monitor_url(ad.getEventTacking().getClickTrackers().get(i));
            clickMonitors.add(clickMonitor);
        }
        bid.setClick_monitors(clickMonitors);

        List<ImpMonitor> impMonitors = Lists.newArrayList();
        for (int i = 0; i < ad.getEventTacking().getImpressionTrackers().size(); i++) {
            ImpMonitor impMonitor = new ImpMonitor();
            impMonitor.setImp_monitor_url(ad.getEventTacking().getImpressionTrackers().get(i));
            impMonitors.add(impMonitor);
        }
        bid.setImp_monitors(impMonitors);

        //素材
        bid.setCreate_id(ad.getAdid());
        bid.setA_native(getNative(ad));

        List<Bid> bids = Lists.newArrayList();
        bids.add(bid);
        SeatBid seatBid = new SeatBid();
        seatBid.setDspId(config.getDspId());
        seatBid.setBid(bids);

        //竞价信息
        List<SeatBid> seatBids = Lists.newArrayList();
        seatBids.add(seatBid);

        //返回对象填充
        BidResponse bidResponse = new BidResponse();
        bidResponse.setSeat_bid(seatBids);
        //bidResponse.setId(response.getResponseId());
        bidResponse.setTrack_id(inMobiResponse.getRequestId());
        return bidResponse;
    }

    /**
     * 素材信息
     *
     * @return
     */
    private com.bxm.adx.common.sell.response.Native getNative(Ad ad) {
        com.bxm.adx.common.sell.response.Native na = new com.bxm.adx.common.sell.response.Native();
        final MaterialMeta pubContent = ad.getPubContent();
        //大图 还有小图
        final com.bxm.adx.plugins.inmobi.entity.resp.Image screenshots = pubContent.getScreenshots();
        List<Asset> assets = new ArrayList<>();
        Asset asset = new Asset();
        asset.setId(ad.getAdid());
        Image image = new Image();
        image.setUrl(screenshots.getUrl());
        image.setH(screenshots.getWidth());
        image.setW(screenshots.getHeight());
        asset.setImg(image);
        asset.setRequired(0);
        asset.setType(7);
        assets.add(asset);
        na.setAssets(assets);
        return na;
    }

    /**
     * 返回内容解析成实体类
     *
     * @param response
     * @return
     */
    private InMobiResponse convert(byte[] response) {
        final JSONObject parse = JSON.parseObject(response, JSONObject.class);
        final JSONArray ads = parse.getJSONArray("ads");
        InMobiResponse inMobiResponse = JsonHelper.convert(response, InMobiResponse.class);
        JSONObject ad = ads.getJSONObject(0);
        inMobiResponse.getAds().get(0).setPubContent(JsonHelper.convert(ad.getString("pubContent"), MaterialMeta.class));
        inMobiResponse.getAds().get(0).setEventTacking(JsonHelper.convert(ad.getString("eventTracking"), EventTacking.class));
        return inMobiResponse;
    }
}