package com.bxm.adx.plugins.inmobi;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.buyer.AbstractHttpBuyer;
import com.bxm.warcar.dpl2.plugin.PluginConfig;
import com.bxm.warcar.dpl2.plugin.PluginConfigAware;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fgf
 * @since 2020-02-24
 */
@Service
public class InMobiBuyer extends AbstractHttpBuyer implements PluginConfigAware {

    private final InMobiBuyModelAdapter adapter;
    private PluginConfig pluginConfig;

    public InMobiBuyer(AdxProperties properties, InMobiBuyModelAdapter adapter) {
        super(properties);
        this.adapter = adapter;
    }

    @Override
    public String getCode() {
        return pluginConfig.getKey();
    }

    @Override
    public BuyModelAdapter getModelAdapter() {
        return adapter;
    }

    @Override
    public void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    @Override
    protected Map<String, String> getHeaders() {
        Map<String, String> headers = Maps.newHashMap();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        return headers;
    }
}
