package com.bxm.adx.plugins.inmobi;

import com.bxm.warcar.dpl2.plugin.PluginConfig;
import com.bxm.warcar.dpl2.plugin.PluginConfigAware;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Service;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/6 13:53
 */
@Service
public class InmobiPluginConfig implements PluginConfigAware {

    private PluginConfig pluginConfig;

    @Override
    public void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    /**
     * DSP_ID，从数据库里配置的主键ID
     *
     * @return DSP_ID
     */
    Long getDspId() {
        return NumberUtils.toLong(pluginConfig.getProperties().getProperty("dspId"));
    }

    String getKey() {
        return pluginConfig.getKey();
    }
}
