/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.inmobi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.adx.common.AdxException;
import com.bxm.adx.common.adapter.AbstractFastjsonBuyModelAdapter;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherDao;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.Asset;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.plugins.inmobi.InmobiPluginConfig;
import com.bxm.adx.plugins.inmobi.entity.InMobiRequest;
import com.bxm.adx.plugins.inmobi.entity.InMobiResponse;
import com.bxm.adx.plugins.inmobi.entity.req.App;
import com.bxm.adx.plugins.inmobi.entity.req.Banner;
import com.bxm.adx.plugins.inmobi.entity.req.Device;
import com.bxm.adx.plugins.inmobi.entity.req.Imp;
import com.bxm.adx.plugins.inmobi.entity.req.Native;
import com.bxm.adx.plugins.inmobi.entity.resp.Ad;
import com.bxm.adx.plugins.inmobi.entity.resp.EventTacking;
import com.bxm.adx.plugins.inmobi.entity.resp.Image;
import com.bxm.adx.plugins.inmobi.entity.resp.MaterialMeta;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InMobiBuyModelAdapter
extends AbstractFastjsonBuyModelAdapter {
    private static final Logger log = LoggerFactory.getLogger(InMobiBuyModelAdapter.class);
    @Autowired
    private DispatcherDao dispatcherDao;
    @Autowired
    private InmobiPluginConfig config;

    public byte[] buildRequest(BidRequest request) {
        InMobiRequest inMobiRequest = new InMobiRequest();
        List impressions = request.getImps();
        if (CollectionUtils.isEmpty((Collection)impressions)) {
            throw new AdxException("imps is null");
        }
        Impression impression = (Impression)impressions.get(0);
        if (impression == null) {
            throw new AdxException("imp is null");
        }
        com.bxm.adx.common.sell.request.Device device1 = request.getDevice();
        if (device1 == null) {
            throw new AdxException("device is null");
        }
        Dispatcher dispatcher = this.dispatcherDao.get(impression.getTag_id(), this.config.getDspId().toString());
        App app = new App();
        inMobiRequest.setApp(app);
        app.setId(dispatcher.getDspPosid());
        app.setBundle(device1.getBrand());
        Imp imp = new Imp();
        inMobiRequest.setImp(imp);
        Native a = new Native();
        imp.setANative(a);
        a.setLayout(0);
        Banner banner = new Banner();
        imp.setBanner(banner);
        banner.setW(320);
        banner.setH(50);
        imp.setSecure(0);
        imp.setTrackertype("webview");
        Imp.Ext ext = new Imp.Ext();
        ext.setAdsCount(1);
        imp.setExt(ext);
        Device device = Device.builder().connectiontype(device1.getConnection_type()).ifa(device1.getIdfa()).ip(device1.getIp()).md5_imei(device1.getImei_md5()).model(device1.getModel()).o1(DigestUtils.sha1Hex((String)device1.getDpid())).um5(DigestUtils.md5Hex((String)device1.getDpid())).oaid("5a2c009b207deef5").os(device1.getOs()).osv(device1.getOsv()).sha1_imei(DigestUtils.sha1Hex((String)device1.getImei())).type("1").ua(device1.getUa()).build();
        inMobiRequest.setDevice(device);
        InMobiRequest.Ext e = new InMobiRequest.Ext();
        e.setResponseformat("json");
        e.setSupportDeeplink(true);
        return JsonHelper.convert2bytes((Object)inMobiRequest);
    }

    public BidResponse buildResponse(byte[] response) {
        InMobiResponse inMobiResponse = this.convert(response);
        Ad ad = inMobiResponse.getAds().get(0);
        Bid bid = new Bid();
        bid.setPrice(Float.valueOf(0.0f));
        bid.setClick_through_url(ad.getTargetUrl());
        bid.setC_type(Integer.valueOf(6));
        bid.setType(Integer.valueOf(2));
        ArrayList clickMonitors = Lists.newArrayList();
        for (int i = 0; i < ad.getEventTacking().getClickTrackers().size(); ++i) {
            ClickMonitor clickMonitor = new ClickMonitor();
            clickMonitor.setClick_monitor_url(ad.getEventTacking().getClickTrackers().get(i));
            clickMonitors.add(clickMonitor);
        }
        bid.setClick_monitors((List)clickMonitors);
        ArrayList impMonitors = Lists.newArrayList();
        for (int i = 0; i < ad.getEventTacking().getImpressionTrackers().size(); ++i) {
            ImpMonitor impMonitor = new ImpMonitor();
            impMonitor.setImp_monitor_url(ad.getEventTacking().getImpressionTrackers().get(i));
            impMonitors.add(impMonitor);
        }
        bid.setImp_monitors((List)impMonitors);
        bid.setCreate_id(ad.getAdid());
        bid.setA_native(this.getNative(ad));
        ArrayList bids = Lists.newArrayList();
        bids.add(bid);
        SeatBid seatBid = new SeatBid();
        seatBid.setDspId(this.config.getDspId());
        seatBid.setBid((List)bids);
        ArrayList seatBids = Lists.newArrayList();
        seatBids.add(seatBid);
        BidResponse bidResponse = new BidResponse();
        bidResponse.setSeat_bid((List)seatBids);
        bidResponse.setTrack_id(inMobiResponse.getRequestId());
        return bidResponse;
    }

    private com.bxm.adx.common.sell.response.Native getNative(Ad ad) {
        com.bxm.adx.common.sell.response.Native na = new com.bxm.adx.common.sell.response.Native();
        MaterialMeta pubContent = ad.getPubContent();
        Image screenshots = pubContent.getScreenshots();
        ArrayList<Asset> assets = new ArrayList<Asset>();
        Asset asset = new Asset();
        asset.setId(ad.getAdid());
        com.bxm.adx.common.sell.response.Image image = new com.bxm.adx.common.sell.response.Image();
        image.setUrl(screenshots.getUrl());
        image.setH(screenshots.getWidth());
        image.setW(screenshots.getHeight());
        asset.setImg(image);
        asset.setRequired(Integer.valueOf(0));
        asset.setType(Integer.valueOf(7));
        assets.add(asset);
        na.setAssets(assets);
        return na;
    }

    private InMobiResponse convert(byte[] response) {
        JSONObject parse = (JSONObject)JSON.parseObject((byte[])response, JSONObject.class, (Feature[])new Feature[0]);
        JSONArray ads = parse.getJSONArray("ads");
        InMobiResponse inMobiResponse = (InMobiResponse)JsonHelper.convert((byte[])response, InMobiResponse.class);
        JSONObject ad = ads.getJSONObject(0);
        inMobiResponse.getAds().get(0).setPubContent((MaterialMeta)JsonHelper.convert((String)ad.getString("pubContent"), MaterialMeta.class));
        inMobiResponse.getAds().get(0).setEventTacking((EventTacking)JsonHelper.convert((String)ad.getString("eventTracking"), EventTacking.class));
        return inMobiResponse;
    }
}

