/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.zhijie.enums;

import com.bxm.adx.common.AdxConstants;

public enum ActionTypeEnum {
    WEBVIEW(1, "\u843d\u5730\u9875"),
    DOWNLOAD(2, "\u4e0b\u8f7d"),
    DP_WEBVIEW(3, "dp+webview"),
    DP_DOWNLOAD(4, "dp+download"),
    H5_DOWNLOAD(5, "h5+download");

    private Integer code;
    private String desc;

    private ActionTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isDownLoad(Integer type) {
        return !ActionTypeEnum.WEBVIEW.code.equals(type) && !ActionTypeEnum.DP_WEBVIEW.code.equals(type);
    }

    public static Integer toResponseActionType(Integer type, Boolean isAndroid) {
        if (ActionTypeEnum.WEBVIEW.code.equals(type)) {
            return AdxConstants.Action.WEB_VIEW.action;
        }
        if (ActionTypeEnum.DP_WEBVIEW.code.equals(type)) {
            return AdxConstants.Action.DEEP_LINK.action;
        }
        if (ActionTypeEnum.DP_DOWNLOAD.code.equals(type)) {
            return AdxConstants.Action.DEEP_LINK_DOWNLOAD.action;
        }
        if (isAndroid.booleanValue()) {
            return AdxConstants.Action.DOWNLOAD_ANDROID.action;
        }
        return AdxConstants.Action.DOWNLOAD_IOS.action;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

