/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.zhijie.enums;

import com.bxm.adx.common.AdxConstants;

public enum ImpTypeEnum {
    NATIVE(1, "\u4fe1\u606f\u6d41"),
    KAI_PING(2, "\u5f00\u5c4f"),
    BANNER(3, "banner"),
    CHA_PING(4, "\u63d2\u5c4f"),
    INSPIRE_VIDEO(9, "\u6fc0\u52b1\u89c6\u9891");

    private Integer code;
    private String desc;

    private ImpTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer toRequestImpTypeByType(Integer type) {
        if (type == null) {
            return NATIVE.getCode();
        }
        if (AdxConstants.Type.INSPIRE_VIDEO.getType().equals(type)) {
            return INSPIRE_VIDEO.getCode();
        }
        if (AdxConstants.Type.VIDEO.getType().equals(type)) {
            return INSPIRE_VIDEO.getCode();
        }
        if (AdxConstants.Type.IMAGE.getType().equals(type)) {
            return KAI_PING.getCode();
        }
        return NATIVE.getCode();
    }

    public static Integer toRequestImpTypeByImpType(Integer type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case 3: {
                return BANNER.getCode();
            }
            case 4: {
                return CHA_PING.getCode();
            }
            case 2: {
                return KAI_PING.getCode();
            }
            case 8: {
                return INSPIRE_VIDEO.getCode();
            }
            case 1: {
                return NATIVE.getCode();
            }
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

