/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.zhijie.request;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Geo;
import com.bxm.adx.common.sell.request.User;
import com.bxm.adx.plugins.zhijie.enums.CarrierEnum;
import com.bxm.adx.plugins.zhijie.enums.ConnectionTypeEnum;
import com.bxm.adx.plugins.zhijie.enums.DeviceTypeEnum;
import com.bxm.adx.plugins.zhijie.enums.OsEnum;
import com.bxm.adx.plugins.zhijie.request.ZhijieApp;
import com.bxm.adx.plugins.zhijie.request.ZhijieBanner;
import com.bxm.adx.plugins.zhijie.request.ZhijieDevice;
import com.bxm.adx.plugins.zhijie.request.ZhijieGeo;
import com.bxm.adx.plugins.zhijie.request.ZhijieImp;
import com.bxm.adx.plugins.zhijie.request.ZhijieNative;
import com.bxm.adx.plugins.zhijie.request.ZhijieUser;
import com.bxm.adx.plugins.zhijie.request.ZhijieVideo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ZhijieBidRequest {
    private String id;
    private List<ZhijieImp> imp;
    private ZhijieApp app;
    private ZhijieDevice device;
    private ZhijieUser user;
    private Integer secure;

    public static ZhijieBidRequest buildZjRequest(BidRequest bxmRequest) {
        ZhijieBidRequest zhijieBidRequest = new ZhijieBidRequest();
        zhijieBidRequest.setId(bxmRequest.getId());
        ZhijieBidRequest.buildZjApp(zhijieBidRequest, bxmRequest);
        ZhijieBidRequest.buildZjImp(zhijieBidRequest, bxmRequest);
        ZhijieBidRequest.buildDevice(zhijieBidRequest, bxmRequest);
        ZhijieBidRequest.buildUser(zhijieBidRequest, bxmRequest);
        return zhijieBidRequest;
    }

    private static void buildUser(ZhijieBidRequest zhijieBidRequest, BidRequest bxmRequest) {
        User user = bxmRequest.getUser();
        if (user == null) {
            return;
        }
        ZhijieUser zhijieUser = new ZhijieUser();
        Integer gender = user.getGender();
        if (gender != null) {
            if (gender == 1) {
                zhijieUser.setGender("M");
            } else if (gender == 2) {
                zhijieUser.setGender("F");
            }
        }
        zhijieUser.setYob(user.getYob());
        zhijieBidRequest.setUser(zhijieUser);
    }

    private static void buildDevice(ZhijieBidRequest zhijieBidRequest, BidRequest bxmRequest) {
        Device device = bxmRequest.getDevice();
        if (device == null) {
            return;
        }
        ZhijieDevice zhijieDevice = new ZhijieDevice();
        zhijieDevice.setIp(device.getIp());
        zhijieDevice.setUa(device.getUa());
        zhijieDevice.setDevicetype(DeviceTypeEnum.toRequestDeviceType(device.getDevice_type()));
        zhijieDevice.setBrand(device.getBrand());
        zhijieDevice.setModel(device.getModel());
        zhijieDevice.setOs(OsEnum.toZjOs(device.getOs()));
        zhijieDevice.setOsv(device.getOsv());
        zhijieDevice.setCarrier(CarrierEnum.toZjCarrier(device.getCarrier()));
        zhijieDevice.setConnectiontype(ConnectionTypeEnum.toZjConnectionType(device.getConnection_type()));
        String os = device.getOs();
        if ("IOS".equals(os)) {
            zhijieDevice.setDid(StringUtils.isBlank((CharSequence)device.getIdfa_md5()) ? device.getIdfa() : device.getIdfa_md5());
        } else {
            String osv = device.getOsv();
            if (StringUtils.isNotBlank((CharSequence)osv)) {
                int majorVersion = Integer.parseInt(osv.split("\\.")[0]);
                zhijieDevice.setDid(majorVersion >= 10 ? (StringUtils.isBlank((CharSequence)device.getOaid_md5()) ? device.getOaid() : device.getOaid_md5()) : (StringUtils.isBlank((CharSequence)device.getImei_md5()) ? device.getImei() : device.getImei_md5()));
            } else {
                zhijieDevice.setDid(StringUtils.isBlank((CharSequence)device.getImei_md5()) ? device.getImei() : device.getImei_md5());
            }
        }
        zhijieDevice.setAndroidid(StringUtils.isBlank((CharSequence)device.getDpid()) ? device.getDpid_md5() : device.getDpid());
        zhijieDevice.setIdfv(device.getIdfv());
        zhijieDevice.setSh(device.getH());
        zhijieDevice.setSw(device.getW());
        zhijieDevice.setDpi(device.getDpi());
        zhijieDevice.setGeo(ZhijieBidRequest.buildZjGeo(bxmRequest.getGeo()));
        zhijieDevice.setMac(device.getMac());
        zhijieDevice.setImsi(device.getImsi());
        zhijieDevice.setIpv6(device.getIp_v6());
        zhijieDevice.setBootMark(device.getBoot_mark());
        zhijieDevice.setUpdateMark(device.getUpdate_mark());
        zhijieDevice.setIdfa_md5(device.getIdfa_md5());
        zhijieDevice.setImei_md5(device.getImei_md5());
        zhijieDevice.setOaid_md5(device.getOaid_md5());
        zhijieDevice.setAnid_md5(device.getDpid_md5());
        zhijieDevice.setApi_level(device.getAndroid_version());
        zhijieDevice.setDensity(device.getDpi() == null ? null : new Float(device.getDpi().intValue()));
        zhijieDevice.setOrient(device.getOrientation());
        zhijieDevice.setCaid(device.getCaid());
        zhijieDevice.setRomver(device.getRom_version());
        zhijieDevice.setDevice_name_md5(device.getDevice_name_md5());
        zhijieDevice.setStart_time(device.getDevice_start_sec());
        zhijieDevice.setUpdate_time(device.getSystem_update_sec());
        zhijieDevice.setInit_time(device.getBirth_time());
        zhijieDevice.setCpu_num(device.getCpu_num());
        zhijieDevice.setPaid(device.getPaid());
        User user = bxmRequest.getUser();
        if (user != null) {
            zhijieDevice.setInstalled_apps(user.getInstalled_app_list());
        }
        zhijieBidRequest.setDevice(zhijieDevice);
    }

    private static ZhijieGeo buildZjGeo(Geo geo) {
        if (geo == null) {
            return null;
        }
        ZhijieGeo zhijieGeo = new ZhijieGeo();
        zhijieGeo.setLat(zhijieGeo.getLat());
        zhijieGeo.setLon(zhijieGeo.getLon());
        return zhijieGeo;
    }

    private static void buildZjImp(ZhijieBidRequest zhijieBidRequest, BidRequest bxmRequest) {
        List imps = bxmRequest.getImps();
        if (CollectionUtils.isEmpty((Collection)imps)) {
            return;
        }
        ArrayList<ZhijieImp> zjImps = new ArrayList<ZhijieImp>(imps.size());
        imps.forEach(imp -> {
            ZhijieImp zhijieImp = new ZhijieImp();
            zhijieImp.setId(imp.getId());
            zhijieImp.setTagid(imp.getTag_id());
            zhijieImp.setAmount(imp.getNum() == null ? 1 : imp.getNum());
            zhijieImp.setPw(imp.getW());
            zhijieImp.setPh(imp.getH());
            zhijieImp.setBidfloor(imp.getBid_floor().intValue());
            Integer imp_type = imp.getImp_type();
            if (imp_type != null) {
                if (imp_type == 1) {
                    ZhijieNative.ZhijieNativeBuilder builder = ZhijieNative.builder();
                    Integer type = imp.getType();
                    if (type == 4) {
                        builder.mtype(2);
                    } else {
                        builder.mtype(1);
                    }
                    zhijieImp.setAnative(builder.build());
                }
                ZhijieBanner zhijieBanner = new ZhijieBanner();
                if (imp_type == 2) {
                    zhijieBanner.setMtype(2);
                }
                if (imp_type == 4) {
                    zhijieBanner.setMtype(3);
                }
                if (imp_type == 3) {
                    zhijieBanner.setMtype(1);
                }
                zhijieImp.setBanner(zhijieBanner);
                ZhijieVideo zhijieVideo = new ZhijieVideo();
                if (imp_type == 8) {
                    zhijieVideo.setMtype(2);
                }
                if (imp_type == 9) {
                    zhijieVideo.setMtype(1);
                }
                zhijieImp.setVideo(zhijieVideo);
            }
            zjImps.add(zhijieImp);
        });
        zhijieBidRequest.setImp(zjImps);
    }

    private static void buildZjApp(ZhijieBidRequest zhijieBidRequest, BidRequest bxmRequest) {
        App app = bxmRequest.getApp();
        if (app == null) {
            return;
        }
        ZhijieApp zhijieApp = new ZhijieApp();
        zhijieApp.setId("310017");
        zhijieApp.setName(app.getName());
        zhijieApp.setPkg(app.getBundle());
        zhijieApp.setVer(app.getVer());
        zhijieBidRequest.setApp(zhijieApp);
    }

    public String getId() {
        return this.id;
    }

    public List<ZhijieImp> getImp() {
        return this.imp;
    }

    public ZhijieApp getApp() {
        return this.app;
    }

    public ZhijieDevice getDevice() {
        return this.device;
    }

    public ZhijieUser getUser() {
        return this.user;
    }

    public Integer getSecure() {
        return this.secure;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setImp(List<ZhijieImp> imp) {
        this.imp = imp;
    }

    public void setApp(ZhijieApp app) {
        this.app = app;
    }

    public void setDevice(ZhijieDevice device) {
        this.device = device;
    }

    public void setUser(ZhijieUser user) {
        this.user = user;
    }

    public void setSecure(Integer secure) {
        this.secure = secure;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZhijieBidRequest)) {
            return false;
        }
        ZhijieBidRequest other = (ZhijieBidRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$secure = this.getSecure();
        Integer other$secure = other.getSecure();
        if (this$secure == null ? other$secure != null : !((Object)this$secure).equals(other$secure)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<ZhijieImp> this$imp = this.getImp();
        List<ZhijieImp> other$imp = other.getImp();
        if (this$imp == null ? other$imp != null : !((Object)this$imp).equals(other$imp)) {
            return false;
        }
        ZhijieApp this$app = this.getApp();
        ZhijieApp other$app = other.getApp();
        if (this$app == null ? other$app != null : !((Object)this$app).equals(other$app)) {
            return false;
        }
        ZhijieDevice this$device = this.getDevice();
        ZhijieDevice other$device = other.getDevice();
        if (this$device == null ? other$device != null : !((Object)this$device).equals(other$device)) {
            return false;
        }
        ZhijieUser this$user = this.getUser();
        ZhijieUser other$user = other.getUser();
        return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZhijieBidRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $secure = this.getSecure();
        result = result * 59 + ($secure == null ? 43 : ((Object)$secure).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<ZhijieImp> $imp = this.getImp();
        result = result * 59 + ($imp == null ? 43 : ((Object)$imp).hashCode());
        ZhijieApp $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : ((Object)$app).hashCode());
        ZhijieDevice $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : ((Object)$device).hashCode());
        ZhijieUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        return result;
    }

    public String toString() {
        return "ZhijieBidRequest(id=" + this.getId() + ", imp=" + this.getImp() + ", app=" + this.getApp() + ", device=" + this.getDevice() + ", user=" + this.getUser() + ", secure=" + this.getSecure() + ")";
    }
}

