/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.plugins.zhijie.response;

import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.AppMonitor;
import com.bxm.adx.common.sell.response.Asset;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.DownloadInfo;
import com.bxm.adx.common.sell.response.DpMonitor;
import com.bxm.adx.common.sell.response.Image;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.response.Native;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.sell.response.Text;
import com.bxm.adx.common.sell.response.Video;
import com.bxm.adx.common.sell.response.VideoMonitor;
import com.bxm.adx.plugins.zhijie.response.Adm;
import com.bxm.adx.plugins.zhijie.response.AppInfo;
import com.bxm.adx.plugins.zhijie.response.MacroReplacer;
import com.bxm.adx.plugins.zhijie.response.Trackers;
import com.bxm.adx.plugins.zhijie.response.VideoInfo;
import com.bxm.adx.plugins.zhijie.response.VideoTrackers;
import com.bxm.adx.plugins.zhijie.response.ZhijieBid;
import com.bxm.adx.plugins.zhijie.response.ZhijieBidResponse;
import com.bxm.adx.plugins.zhijie.response.ZhijieSeatbid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ResponseBuild {
    public static BidResponse buildBxmResponse(ZhijieBidResponse zhijieBidResponse) {
        BidResponse bidResponse = new BidResponse();
        bidResponse.setId(zhijieBidResponse.getId());
        List<ZhijieSeatbid> seatbids = zhijieBidResponse.getSeatbid();
        ArrayList seatBids = new ArrayList();
        if (CollectionUtils.isNotEmpty(seatbids)) {
            seatbids.forEach(seatbid -> seatBids.add(ResponseBuild.buildSeatBid(seatbid)));
        }
        bidResponse.setSeat_bid(seatBids);
        return bidResponse;
    }

    private static SeatBid buildSeatBid(ZhijieSeatbid seatbid) {
        SeatBid seatBid = new SeatBid();
        List<ZhijieBid> bids = seatbid.getBids();
        ArrayList bxmBids = new ArrayList();
        if (CollectionUtils.isNotEmpty(bids)) {
            bids.forEach(bid -> bxmBids.add(ResponseBuild.buildBid(bid, seatbid.getImpid())));
        }
        seatBid.setBid(bxmBids);
        return seatBid;
    }

    private static Bid buildBid(ZhijieBid bid, String impid) {
        AppInfo app_info;
        VideoInfo video_info;
        Bid bxmBid = new Bid();
        bxmBid.setId(bid.getId());
        bxmBid.setAdid(bid.getAdid());
        bxmBid.setImp_id(impid);
        Adm adm = bid.getAdm();
        if (adm != null) {
            String icon;
            List<String> images;
            Native aNative = new Native();
            ArrayList<Asset> assets = new ArrayList<Asset>();
            String title = adm.getTitle();
            if (StringUtils.isNotBlank((CharSequence)title)) {
                assets.add(Asset.builder().type(Integer.valueOf(1)).text(Text.builder().text(title).build()).build());
            }
            if (CollectionUtils.isNotEmpty(images = adm.getImages())) {
                assets.addAll(images.stream().map(img -> Asset.builder().type(Integer.valueOf(7)).img(Image.builder().url(img).build()).build()).collect(Collectors.toList()));
            }
            if (StringUtils.isNotBlank((CharSequence)(icon = adm.getIcon()))) {
                assets.add(Asset.builder().type(Integer.valueOf(6)).img(Image.builder().url(icon).build()).build());
            }
            aNative.setAssets(assets);
            bxmBid.setA_native(aNative);
        }
        bxmBid.setClick_through_url(bid.getLanding_url());
        bxmBid.setDeep_link_url(bid.getDeeplink());
        bxmBid.setUniversal_link(bid.getUlk());
        bxmBid.setUniversal_link(bid.getUlk());
        String download_url = bid.getDownload_url();
        if (StringUtils.isNotBlank((CharSequence)download_url)) {
            bxmBid.setDownload_info(DownloadInfo.builder().downloadUrl(download_url).build());
        }
        bxmBid.setPrice(bid.getPrice() == null ? new BigDecimal(0) : new BigDecimal(bid.getPrice()));
        List<String> win_urls = bid.getWin_urls();
        if (CollectionUtils.isNotEmpty(win_urls)) {
            bxmBid.setImp_monitors(win_urls.stream().map(winUrl -> ImpMonitor.builder().imp_monitor_url(winUrl).build()).collect(Collectors.toList()));
        }
        bxmBid.setMini_app_name(bid.getApplet_id());
        bxmBid.setMini_app_path(bid.getApplet_path());
        Trackers trackers = bid.getTrackers();
        if (trackers != null) {
            List<String> click_trackers;
            List<String> imp_trackers = trackers.getImp_trackers();
            if (CollectionUtils.isNotEmpty(imp_trackers)) {
                bxmBid.getImp_monitors().addAll(imp_trackers.stream().map(impTracker -> ImpMonitor.builder().imp_monitor_url(impTracker).build()).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty(click_trackers = trackers.getClick_trackers())) {
                bxmBid.setClick_monitors(click_trackers.stream().map(click -> ClickMonitor.builder().click_monitor_url(click).build()).collect(Collectors.toList()));
            }
            DpMonitor dpMonitor = new DpMonitor();
            dpMonitor.setAwk_success_urls(trackers.getDeeplink_trackers());
            dpMonitor.setAwk_fail_urls(trackers.getDeeplink_fail_trackers());
            bxmBid.setDpMonitor(dpMonitor);
            AppMonitor appMonitor = new AppMonitor();
            appMonitor.setDs_urls(trackers.getStart_download_trackers());
            appMonitor.setDf_urls(trackers.getFinish_download_trackers());
            appMonitor.setSs_urls(trackers.getStart_install_trackers());
            appMonitor.setSf_urls(trackers.getFinish_install_trackers());
            appMonitor.setAct_urls(trackers.getOpen_app_trackers());
            bxmBid.setApp_monitor(appMonitor);
        }
        if ((video_info = bid.getVideo_info()) != null) {
            Video.VideoBuilder videoBuilder = Video.builder().url(video_info.getUrl()).duration(video_info.getDuration()).max_length(video_info.getSize()).w(video_info.getWidth()).h(video_info.getHeight()).cover_url(video_info.getCover());
            VideoTrackers video_trackers = bid.getVideo_trackers();
            if (video_trackers != null) {
                videoBuilder.v_monitor(VideoMonitor.builder().v_start_urls(video_trackers.getPlay_start_trackers()).v_end_urls(video_trackers.getPlay_finish_trackers()).v_quarter_urls(video_trackers.getPlay_25ps_trackers()).v_half_urls(video_trackers.getPlay_50ps_trackers()).v_three_quarter_urls(video_trackers.getPlay_75ps_trackers()).v_suspend_urls(video_trackers.getPause_trackers()).v_close_urls(video_trackers.getClose_trackers()).build());
            }
            bxmBid.getA_native().getAssets().add(Asset.builder().type(Integer.valueOf(11)).video(videoBuilder.build()).build());
        }
        if ((app_info = bid.getApp_info()) != null) {
            DownloadInfo download_info = bxmBid.getDownload_info();
            download_info.setAppName(app_info.getName());
            download_info.setAppPackageName(app_info.getPkg());
            download_info.setAppSize(app_info.getSize() == null ? null : new BigDecimal(app_info.getSize()));
            download_info.setVersion(app_info.getVersion());
            download_info.setPrivacyAgreementUrl(app_info.getPrivacy_url());
            download_info.setUserRightsUrl(app_info.getPerm_url());
            download_info.setDeveloperName(app_info.getDeveloper());
            download_info.setAppIconUrl(app_info.getIcon());
        }
        bxmBid.getImp_monitors().forEach(impMonitor -> impMonitor.setImp_monitor_url(MacroReplacer.replaceImpUrl(impMonitor.getImp_monitor_url())));
        bxmBid.getClick_monitors().forEach(clickMonitor -> clickMonitor.setClick_monitor_url(MacroReplacer.replaceClickUrls(clickMonitor.getClick_monitor_url())));
        return bxmBid;
    }
}

