package com.bxm.adxcounter.facade.model;

import java.io.Serializable;

import lombok.Data;

/**
 * 公共参数<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 13:53
 */
@Data
public abstract class AbstractCounterDTO implements Serializable {

    private static final long serialVersionUID = -4805979249918133754L;
    
    /**
     * 时间戳（timestamp）
     */
    private String t;
    /**
     * 用户IP地址
     */
    private String ip;
    /**
     * User-Agent
     */
    private String ua;
    /**
     * MAC地址
     */
    private String mac;
    /**
     * 系统类型
     * 0:未知
     * 1:安卓
     * 2:IOS
     */
    private String os;
    /**
     * IMEI，所属安卓
     */
    private String imei;
    /**
     * 安卓ID（androidId），所属安卓10.0以上
     */
    private String anid;
    /**
     * open device id，第三方设备唯一标识
     */
    private String odid;
    /**
     * IDFA，所属IOS
     */
    private String idfa;
    /**
     * 设备品牌（deviceBrand）,如：华为
     */
    private String devb;
    /**
     * 设备型号（deviceModel）,如：华为 mate 10 pro
     */
    private String devm;
    /**
     * 联网方式（netType）
     * 0:未知
     * 1:以太网
     * 2:Wifi网络
     * 3:蜂窝数据网络-2G
     * 4:蜂窝数据网络-3G
     * 5:蜂窝数据网络-4G
     * 6:蜂窝数据网络-5G
     * 7:蜂窝数据网络-未知
     */
    private String net;
    /**
     * 经度（longitude）
     */
    private String lon;
    /**
     * 纬度（latitude）
     */
    private String lat;
}
